@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.PlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The promotion code.
 * @property publisher The publisher ID.
 */
public data class PlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.PlanArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.PlanArgs =
        com.pulumi.azurenative.compute.inputs.PlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The plan ID.
     */
    @JvmName("kxrjesxktqbgupul")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("swofmusfghwskjdu")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("lqrovnlqtrxrangq")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("iikduokcvmwiilvo")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("ivklnxcdvkfjinoq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("nbnbnbynihrakxqt")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("iriibyortqaafiuu")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("avjjorcxvpriuayl")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        name = name,
        product = product,
        promotionCode = promotionCode,
        publisher = publisher,
    )
}
