@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointEncryptionArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.RestorePointEncryptionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
 * @property diskEncryptionSet Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
 * @property type The type of key used to encrypt the data of the disk restore point.
 */
public data class RestorePointEncryptionArgs(
    public val diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null,
    public val type: Output<Either<String, RestorePointEncryptionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RestorePointEncryptionArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointEncryptionArgs.builder()
            .diskEncryptionSet(diskEncryptionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RestorePointEncryptionArgs].
 */
@PulumiTagMarker
public class RestorePointEncryptionArgsBuilder internal constructor() {
    private var diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null

    private var type: Output<Either<String, RestorePointEncryptionType>>? = null

    /**
     * @param value Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
     */
    @JvmName("drlapdahmuepxruh")
    public suspend fun diskEncryptionSet(`value`: Output<DiskEncryptionSetParametersArgs>) {
        this.diskEncryptionSet = value
    }

    /**
     * @param value The type of key used to encrypt the data of the disk restore point.
     */
    @JvmName("yxorcjsukfxwpbnb")
    public suspend fun type(`value`: Output<Either<String, RestorePointEncryptionType>>) {
        this.type = value
    }

    /**
     * @param value Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
     */
    @JvmName("pcjeyffebrsjtlwx")
    public suspend fun diskEncryptionSet(`value`: DiskEncryptionSetParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSet = mapped
    }

    /**
     * @param argument Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
     */
    @JvmName("fegxrvaoxrexqjeg")
    public suspend
    fun diskEncryptionSet(argument: suspend DiskEncryptionSetParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionSetParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionSet = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk restore point.
     */
    @JvmName("roixjliuhmuyoacb")
    public suspend fun type(`value`: Either<String, RestorePointEncryptionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk restore point.
     */
    @JvmName("stpemvmfckwccnvu")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RestorePointEncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk restore point.
     */
    @JvmName("bbmjojlomtxxqica")
    public fun type(`value`: RestorePointEncryptionType) {
        val toBeMapped = Either.ofRight<String, RestorePointEncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RestorePointEncryptionArgs = RestorePointEncryptionArgs(
        diskEncryptionSet = diskEncryptionSet,
        type = type,
    )
}
