@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a run command parameter.
 * @property name The run command parameter name.
 * @property value The run command parameter value.
 */
public data class RunCommandInputParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs =
        com.pulumi.azurenative.compute.inputs.RunCommandInputParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RunCommandInputParameterArgs].
 */
@PulumiTagMarker
public class RunCommandInputParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The run command parameter name.
     */
    @JvmName("rutttdbrvqgiywds")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The run command parameter value.
     */
    @JvmName("flqwecadangjkbab")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The run command parameter name.
     */
    @JvmName("tbiwgxfjhkmwhtks")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The run command parameter value.
     */
    @JvmName("kovdsyqixqfrqqxe")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RunCommandInputParameterArgs = RunCommandInputParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
