@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
 * @property capacity Specifies the number of virtual machines in the scale set.
 * @property name The sku name.
 * @property tier Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
 */
public data class SkuArgs(
    public val capacity: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SkuArgs =
        com.pulumi.azurenative.compute.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Double>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Specifies the number of virtual machines in the scale set.
     */
    @JvmName("irvcvmhqmcfmpsio")
    public suspend fun capacity(`value`: Output<Double>) {
        this.capacity = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("xfvlufphopromusi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
     */
    @JvmName("fxuiumgecxerjhvn")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Specifies the number of virtual machines in the scale set.
     */
    @JvmName("rxvmclojwdlaoxud")
    public suspend fun capacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("ijftpojnvguglijt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
     */
    @JvmName("bcoyyxbiqhtywlxk")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
