@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SnapshotSkuArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.SnapshotStorageAccountTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
 * @property name The sku name.
 */
public data class SnapshotSkuArgs(
    public val name: Output<Either<String, SnapshotStorageAccountTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SnapshotSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SnapshotSkuArgs =
        com.pulumi.azurenative.compute.inputs.SnapshotSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SnapshotSkuArgs].
 */
@PulumiTagMarker
public class SnapshotSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, SnapshotStorageAccountTypes>>? = null

    /**
     * @param value The sku name.
     */
    @JvmName("vjxrkkntmkwuwdas")
    public suspend fun name(`value`: Output<Either<String, SnapshotStorageAccountTypes>>) {
        this.name = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("fvnevpmwjalnjumj")
    public suspend fun name(`value`: Either<String, SnapshotStorageAccountTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("acnvdfttqxvlvsjg")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SnapshotStorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("salwtinggykbfmpv")
    public fun name(`value`: SnapshotStorageAccountTypes) {
        val toBeMapped = Either.ofRight<String, SnapshotStorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SnapshotSkuArgs = SnapshotSkuArgs(
        name = name,
    )
}
