@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SubResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Sub-resource ID. Both absolute resource ID and a relative resource ID are accepted.
 * An absolute ID starts with /subscriptions/ and contains the entire ID of the parent resource and the ID of the sub-resource in the end.
 * A relative ID replaces the ID of the parent resource with a token '$self', followed by the sub-resource ID itself.
 * Example of a relative ID: $self/frontEndConfigurations/my-frontend.
 */
public data class SubResourceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SubResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SubResourceArgs =
        com.pulumi.azurenative.compute.inputs.SubResourceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubResourceArgs].
 */
@PulumiTagMarker
public class SubResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Sub-resource ID. Both absolute resource ID and a relative resource ID are accepted.
     * An absolute ID starts with /subscriptions/ and contains the entire ID of the parent resource and the ID of the sub-resource in the end.
     * A relative ID replaces the ID of the parent resource with a token '$self', followed by the sub-resource ID itself.
     * Example of a relative ID: $self/frontEndConfigurations/my-frontend.
     */
    @JvmName("rfpjierskcdlaicr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Sub-resource ID. Both absolute resource ID and a relative resource ID are accepted.
     * An absolute ID starts with /subscriptions/ and contains the entire ID of the parent resource and the ID of the sub-resource in the end.
     * A relative ID replaces the ID of the parent resource with a token '$self', followed by the sub-resource ID itself.
     * Example of a relative ID: $self/frontEndConfigurations/my-frontend.
     */
    @JvmName("cfbmqeutthicwfjx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SubResourceArgs = SubResourceArgs(
        id = id,
    )
}
