@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SupportedCapabilitiesArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.Architecture
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of supported capabilities persisted on the disk resource for VM use.
 * @property acceleratedNetwork True if the image from which the OS disk is created supports accelerated networking.
 * @property architecture CPU architecture supported by an OS disk.
 * @property diskControllerTypes The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
 */
public data class SupportedCapabilitiesArgs(
    public val acceleratedNetwork: Output<Boolean>? = null,
    public val architecture: Output<Either<String, Architecture>>? = null,
    public val diskControllerTypes: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SupportedCapabilitiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SupportedCapabilitiesArgs =
        com.pulumi.azurenative.compute.inputs.SupportedCapabilitiesArgs.builder()
            .acceleratedNetwork(acceleratedNetwork?.applyValue({ args0 -> args0 }))
            .architecture(
                architecture?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskControllerTypes(diskControllerTypes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SupportedCapabilitiesArgs].
 */
@PulumiTagMarker
public class SupportedCapabilitiesArgsBuilder internal constructor() {
    private var acceleratedNetwork: Output<Boolean>? = null

    private var architecture: Output<Either<String, Architecture>>? = null

    private var diskControllerTypes: Output<String>? = null

    /**
     * @param value True if the image from which the OS disk is created supports accelerated networking.
     */
    @JvmName("ypofcykeycatqpqe")
    public suspend fun acceleratedNetwork(`value`: Output<Boolean>) {
        this.acceleratedNetwork = value
    }

    /**
     * @param value CPU architecture supported by an OS disk.
     */
    @JvmName("eeafvfmcbfgbftph")
    public suspend fun architecture(`value`: Output<Either<String, Architecture>>) {
        this.architecture = value
    }

    /**
     * @param value The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
     */
    @JvmName("cjjwtohkwpbgvenj")
    public suspend fun diskControllerTypes(`value`: Output<String>) {
        this.diskControllerTypes = value
    }

    /**
     * @param value True if the image from which the OS disk is created supports accelerated networking.
     */
    @JvmName("bjsvgriovisukiia")
    public suspend fun acceleratedNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratedNetwork = mapped
    }

    /**
     * @param value CPU architecture supported by an OS disk.
     */
    @JvmName("rsjihdrygjjegvha")
    public suspend fun architecture(`value`: Either<String, Architecture>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value CPU architecture supported by an OS disk.
     */
    @JvmName("acofalqjtitkvsql")
    public fun architecture(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value CPU architecture supported by an OS disk.
     */
    @JvmName("sfeggjbujvaddqiu")
    public fun architecture(`value`: Architecture) {
        val toBeMapped = Either.ofRight<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
     */
    @JvmName("roquxcuckeobrcxu")
    public suspend fun diskControllerTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskControllerTypes = mapped
    }

    internal fun build(): SupportedCapabilitiesArgs = SupportedCapabilitiesArgs(
        acceleratedNetwork = acceleratedNetwork,
        architecture = architecture,
        diskControllerTypes = diskControllerTypes,
    )
}
