@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.UserArtifactManageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property install Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
 * @property remove Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
 * @property update Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
 */
public data class UserArtifactManageArgs(
    public val install: Output<String>,
    public val remove: Output<String>,
    public val update: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.UserArtifactManageArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.UserArtifactManageArgs =
        com.pulumi.azurenative.compute.inputs.UserArtifactManageArgs.builder()
            .install(install.applyValue({ args0 -> args0 }))
            .remove(remove.applyValue({ args0 -> args0 }))
            .update(update?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArtifactManageArgs].
 */
@PulumiTagMarker
public class UserArtifactManageArgsBuilder internal constructor() {
    private var install: Output<String>? = null

    private var remove: Output<String>? = null

    private var update: Output<String>? = null

    /**
     * @param value Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
     */
    @JvmName("lgdemoupvsjlvpcr")
    public suspend fun install(`value`: Output<String>) {
        this.install = value
    }

    /**
     * @param value Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
     */
    @JvmName("eeexwdbvssewmdxl")
    public suspend fun remove(`value`: Output<String>) {
        this.remove = value
    }

    /**
     * @param value Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
     */
    @JvmName("akiloutpboqrqnbf")
    public suspend fun update(`value`: Output<String>) {
        this.update = value
    }

    /**
     * @param value Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
     */
    @JvmName("esnwphawurxihirb")
    public suspend fun install(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.install = mapped
    }

    /**
     * @param value Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
     */
    @JvmName("choqflkxulnwcsyo")
    public suspend fun remove(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remove = mapped
    }

    /**
     * @param value Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
     */
    @JvmName("wptjuwjbivtavilj")
    public suspend fun update(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.update = mapped
    }

    internal fun build(): UserArtifactManageArgs = UserArtifactManageArgs(
        install = install ?: throw PulumiNullFieldException("install"),
        remove = remove ?: throw PulumiNullFieldException("remove"),
        update = update,
    )
}
