@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.UserArtifactSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
 * @property configFileName Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended with "_config".
 * @property packageFileName Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application name.
 */
public data class UserArtifactSettingsArgs(
    public val configFileName: Output<String>? = null,
    public val packageFileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.UserArtifactSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.UserArtifactSettingsArgs =
        com.pulumi.azurenative.compute.inputs.UserArtifactSettingsArgs.builder()
            .configFileName(configFileName?.applyValue({ args0 -> args0 }))
            .packageFileName(packageFileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArtifactSettingsArgs].
 */
@PulumiTagMarker
public class UserArtifactSettingsArgsBuilder internal constructor() {
    private var configFileName: Output<String>? = null

    private var packageFileName: Output<String>? = null

    /**
     * @param value Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended with "_config".
     */
    @JvmName("lwxfgmubuvaqpvwy")
    public suspend fun configFileName(`value`: Output<String>) {
        this.configFileName = value
    }

    /**
     * @param value Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application name.
     */
    @JvmName("cjqjfcrmrpiehakp")
    public suspend fun packageFileName(`value`: Output<String>) {
        this.packageFileName = value
    }

    /**
     * @param value Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended with "_config".
     */
    @JvmName("spfdtayoprnyowgh")
    public suspend fun configFileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configFileName = mapped
    }

    /**
     * @param value Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application name.
     */
    @JvmName("voehcxtrelotvyqi")
    public suspend fun packageFileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFileName = mapped
    }

    internal fun build(): UserArtifactSettingsArgs = UserArtifactSettingsArgs(
        configFileName = configFileName,
        packageFileName = packageFileName,
    )
}
