@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set extension profile.
 * @property extensions The virtual machine scale set child extension resources.
 * @property extensionsTimeBudget Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
 */
public data class VirtualMachineScaleSetExtensionProfileArgs(
    public val extensions: Output<List<VirtualMachineScaleSetExtensionArgs>>? = null,
    public val extensionsTimeBudget: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionProfileArgs.builder()
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extensionsTimeBudget(extensionsTimeBudget?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetExtensionProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetExtensionProfileArgsBuilder internal constructor() {
    private var extensions: Output<List<VirtualMachineScaleSetExtensionArgs>>? = null

    private var extensionsTimeBudget: Output<String>? = null

    /**
     * @param value The virtual machine scale set child extension resources.
     */
    @JvmName("tqapkjtpwiqlsutr")
    public suspend fun extensions(`value`: Output<List<VirtualMachineScaleSetExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("huyidvxmrkdctsus")
    public suspend fun extensions(vararg values: Output<VirtualMachineScaleSetExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values The virtual machine scale set child extension resources.
     */
    @JvmName("xhlbgiuevbfnmhyx")
    public suspend fun extensions(values: List<Output<VirtualMachineScaleSetExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
     */
    @JvmName("uulsjkghgyddiunu")
    public suspend fun extensionsTimeBudget(`value`: Output<String>) {
        this.extensionsTimeBudget = value
    }

    /**
     * @param value The virtual machine scale set child extension resources.
     */
    @JvmName("ybwdpntxkrltsskh")
    public suspend fun extensions(`value`: List<VirtualMachineScaleSetExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument The virtual machine scale set child extension resources.
     */
    @JvmName("goqichfyyjatqtor")
    public suspend
    fun extensions(argument: List<suspend VirtualMachineScaleSetExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetExtensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument The virtual machine scale set child extension resources.
     */
    @JvmName("qbruvjepvdcmbxoh")
    public suspend fun extensions(
        vararg
        argument: suspend VirtualMachineScaleSetExtensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetExtensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument The virtual machine scale set child extension resources.
     */
    @JvmName("irpdqvxblmektgsl")
    public suspend
    fun extensions(argument: suspend VirtualMachineScaleSetExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetExtensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values The virtual machine scale set child extension resources.
     */
    @JvmName("jmkgotlukvgfnuny")
    public suspend fun extensions(vararg values: VirtualMachineScaleSetExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
     */
    @JvmName("sdjcadvfsyfibpnn")
    public suspend fun extensionsTimeBudget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionsTimeBudget = mapped
    }

    internal fun build(): VirtualMachineScaleSetExtensionProfileArgs =
        VirtualMachineScaleSetExtensionProfileArgs(
            extensions = extensions,
            extensionsTimeBudget = extensionsTimeBudget,
        )
}
