@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetIPConfigurationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set network profile's IP configuration.
 * @property applicationGatewayBackendAddressPools Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
 * @property applicationSecurityGroups Specifies an array of references to application security group.
 * @property loadBalancerBackendAddressPools Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
 * @property loadBalancerInboundNatPools Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
 * @property name The IP configuration name.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 * @property privateIPAddressVersion Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPAddressConfiguration The publicIPAddressConfiguration.
 * @property subnet Specifies the identifier of the subnet.
 */
public data class VirtualMachineScaleSetIPConfigurationArgs(
    public val applicationGatewayBackendAddressPools: Output<List<SubResourceArgs>>? = null,
    public val applicationSecurityGroups: Output<List<SubResourceArgs>>? = null,
    public val loadBalancerBackendAddressPools: Output<List<SubResourceArgs>>? = null,
    public val loadBalancerInboundNatPools: Output<List<SubResourceArgs>>? = null,
    public val name: Output<String>,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val publicIPAddressConfiguration:
    Output<VirtualMachineScaleSetPublicIPAddressConfigurationArgs>? = null,
    public val subnet: Output<ApiEntityReferenceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetIPConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetIPConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetIPConfigurationArgs.builder()
            .applicationGatewayBackendAddressPools(
                applicationGatewayBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .applicationSecurityGroups(
                applicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancerBackendAddressPools(
                loadBalancerBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .loadBalancerInboundNatPools(
                loadBalancerInboundNatPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddressVersion(
                privateIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddressConfiguration(
                publicIPAddressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineScaleSetIPConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetIPConfigurationArgsBuilder internal constructor() {
    private var applicationGatewayBackendAddressPools: Output<List<SubResourceArgs>>? = null

    private var applicationSecurityGroups: Output<List<SubResourceArgs>>? = null

    private var loadBalancerBackendAddressPools: Output<List<SubResourceArgs>>? = null

    private var loadBalancerInboundNatPools: Output<List<SubResourceArgs>>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var publicIPAddressConfiguration:
        Output<VirtualMachineScaleSetPublicIPAddressConfigurationArgs>? = null

    private var subnet: Output<ApiEntityReferenceArgs>? = null

    /**
     * @param value Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("rkltynrcqfhkeyop")
    public suspend fun applicationGatewayBackendAddressPools(`value`: Output<List<SubResourceArgs>>) {
        this.applicationGatewayBackendAddressPools = value
    }

    @JvmName("dwgtgklrkntaggbl")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: Output<SubResourceArgs>) {
        this.applicationGatewayBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("nlufcfgdqcmfqdom")
    public suspend fun applicationGatewayBackendAddressPools(values: List<Output<SubResourceArgs>>) {
        this.applicationGatewayBackendAddressPools = Output.all(values)
    }

    /**
     * @param value Specifies an array of references to application security group.
     */
    @JvmName("jakqgjsceiwahjgf")
    public suspend fun applicationSecurityGroups(`value`: Output<List<SubResourceArgs>>) {
        this.applicationSecurityGroups = value
    }

    @JvmName("swhombsfqjvxlcng")
    public suspend fun applicationSecurityGroups(vararg values: Output<SubResourceArgs>) {
        this.applicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to application security group.
     */
    @JvmName("cienjmevutirfffh")
    public suspend fun applicationSecurityGroups(values: List<Output<SubResourceArgs>>) {
        this.applicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("sfttdsyymbnunnsk")
    public suspend fun loadBalancerBackendAddressPools(`value`: Output<List<SubResourceArgs>>) {
        this.loadBalancerBackendAddressPools = value
    }

    @JvmName("vvyoljwnxgtcnjkn")
    public suspend fun loadBalancerBackendAddressPools(vararg values: Output<SubResourceArgs>) {
        this.loadBalancerBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("ufbjaluwafupttrl")
    public suspend fun loadBalancerBackendAddressPools(values: List<Output<SubResourceArgs>>) {
        this.loadBalancerBackendAddressPools = Output.all(values)
    }

    /**
     * @param value Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("dkbxmtyfujnlquog")
    public suspend fun loadBalancerInboundNatPools(`value`: Output<List<SubResourceArgs>>) {
        this.loadBalancerInboundNatPools = value
    }

    @JvmName("venbgthpmmllejwg")
    public suspend fun loadBalancerInboundNatPools(vararg values: Output<SubResourceArgs>) {
        this.loadBalancerInboundNatPools = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("ujkpbnvbhfruqovm")
    public suspend fun loadBalancerInboundNatPools(values: List<Output<SubResourceArgs>>) {
        this.loadBalancerInboundNatPools = Output.all(values)
    }

    /**
     * @param value The IP configuration name.
     */
    @JvmName("ncjfxlmvthyetehg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("qhesnnhogfvwwuyg")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("erqyropcfdchqtcs")
    public suspend fun privateIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.privateIPAddressVersion = value
    }

    /**
     * @param value The publicIPAddressConfiguration.
     */
    @JvmName("ddypbqiqwnuxsghs")
    public suspend
    fun publicIPAddressConfiguration(`value`: Output<VirtualMachineScaleSetPublicIPAddressConfigurationArgs>) {
        this.publicIPAddressConfiguration = value
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("mfhiciopkgaoebse")
    public suspend fun subnet(`value`: Output<ApiEntityReferenceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("vcmgacqgjeeglvqa")
    public suspend fun applicationGatewayBackendAddressPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("boyncjpyiadndrvh")
    public suspend
    fun applicationGatewayBackendAddressPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("srrhmgymlbcfneni")
    public suspend fun applicationGatewayBackendAddressPools(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("nwfkuafxyuypsrlm")
    public suspend
    fun applicationGatewayBackendAddressPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param values Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
     */
    @JvmName("juagretychotegox")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param value Specifies an array of references to application security group.
     */
    @JvmName("jiuyxemhikdrhnhh")
    public suspend fun applicationSecurityGroups(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("ussebsdreqrpexml")
    public suspend
    fun applicationSecurityGroups(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("uvpcsvwhbdtaftcj")
    public suspend fun applicationSecurityGroups(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("wopkhkhojrjosqtc")
    public suspend
    fun applicationSecurityGroups(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param values Specifies an array of references to application security group.
     */
    @JvmName("nycwdpekhvijktsh")
    public suspend fun applicationSecurityGroups(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param value Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("hveogwrvxmivdwyd")
    public suspend fun loadBalancerBackendAddressPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("djluhshcqxksscpt")
    public suspend
    fun loadBalancerBackendAddressPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("tmunpvqwkaxwlvvx")
    public suspend fun loadBalancerBackendAddressPools(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("hxerjppfoyjufrwv")
    public suspend
    fun loadBalancerBackendAddressPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param values Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("wtdaxycisvwwtjwx")
    public suspend fun loadBalancerBackendAddressPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param value Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("cblgufowitqqhksp")
    public suspend fun loadBalancerInboundNatPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerInboundNatPools = mapped
    }

    /**
     * @param argument Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("pltipdytwrbfssxn")
    public suspend
    fun loadBalancerInboundNatPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatPools = mapped
    }

    /**
     * @param argument Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("uydfyldwfvuifdbm")
    public suspend fun loadBalancerInboundNatPools(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatPools = mapped
    }

    /**
     * @param argument Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("vqhpipxlyxqyxcyu")
    public suspend
    fun loadBalancerInboundNatPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatPools = mapped
    }

    /**
     * @param values Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
     */
    @JvmName("oncpvfhygdyvoqxl")
    public suspend fun loadBalancerInboundNatPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerInboundNatPools = mapped
    }

    /**
     * @param value The IP configuration name.
     */
    @JvmName("mwmumxcqquefvmei")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("yrufhhauwcivvbtw")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("rrvdhlavvtjkaldv")
    public suspend fun privateIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("yvlyducmrlwyjjbw")
    public fun privateIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("wbmcqlwfvvrtckdv")
    public fun privateIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value The publicIPAddressConfiguration.
     */
    @JvmName("lifhikndcbyouxfa")
    public suspend
    fun publicIPAddressConfiguration(`value`: VirtualMachineScaleSetPublicIPAddressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param argument The publicIPAddressConfiguration.
     */
    @JvmName("jyglcxsppqfarhss")
    public suspend
    fun publicIPAddressConfiguration(argument: suspend VirtualMachineScaleSetPublicIPAddressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetPublicIPAddressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("uhadetowqsbjfxes")
    public suspend fun subnet(`value`: ApiEntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Specifies the identifier of the subnet.
     */
    @JvmName("yrwxewcormsxjhyq")
    public suspend fun subnet(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): VirtualMachineScaleSetIPConfigurationArgs =
        VirtualMachineScaleSetIPConfigurationArgs(
            applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools,
            applicationSecurityGroups = applicationSecurityGroups,
            loadBalancerBackendAddressPools = loadBalancerBackendAddressPools,
            loadBalancerInboundNatPools = loadBalancerInboundNatPools,
            name = name ?: throw PulumiNullFieldException("name"),
            primary = primary,
            privateIPAddressVersion = privateIPAddressVersion,
            publicIPAddressConfiguration = publicIPAddressConfiguration,
            subnet = subnet,
        )
}
