@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DeleteOptions
import com.pulumi.azurenative.compute.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
 * @property deleteOption Specify what happens to the public IP when the VM is deleted
 * @property dnsSettings The dns settings to be applied on the publicIP addresses .
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipTags The list of IP tags associated with the public IP address.
 * @property name The publicIP address configuration name.
 * @property publicIPAddressVersion Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPPrefix The PublicIPPrefix from which to allocate publicIP addresses.
 * @property sku Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationArgs(
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val dnsSettings: Output<VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs>? =
        null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val ipTags: Output<List<VirtualMachineScaleSetIpTagArgs>>? = null,
    public val name: Output<String>,
    public val publicIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val publicIPPrefix: Output<SubResourceArgs>? = null,
    public val sku: Output<PublicIPAddressSkuArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs.builder()
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .publicIPAddressVersion(
                publicIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPPrefix(publicIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineScaleSetPublicIPAddressConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetPublicIPAddressConfigurationArgsBuilder internal constructor() {
    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var dnsSettings:
        Output<VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var ipTags: Output<List<VirtualMachineScaleSetIpTagArgs>>? = null

    private var name: Output<String>? = null

    private var publicIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var publicIPPrefix: Output<SubResourceArgs>? = null

    private var sku: Output<PublicIPAddressSkuArgs>? = null

    /**
     * @param value Specify what happens to the public IP when the VM is deleted
     */
    @JvmName("uhptgejaxgedlpxc")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("gsjdwbdbgcqikvgd")
    public suspend
    fun dnsSettings(`value`: Output<VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("oiejlvmqusnhncif")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The list of IP tags associated with the public IP address.
     */
    @JvmName("buhwchdlvwsdpfjs")
    public suspend fun ipTags(`value`: Output<List<VirtualMachineScaleSetIpTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("dipikfmuwruuthrg")
    public suspend fun ipTags(vararg values: Output<VirtualMachineScaleSetIpTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of IP tags associated with the public IP address.
     */
    @JvmName("gcynphsudlnluhvt")
    public suspend fun ipTags(values: List<Output<VirtualMachineScaleSetIpTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value The publicIP address configuration name.
     */
    @JvmName("aalauluawidmllyl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("flbhislabnxvnnwq")
    public suspend fun publicIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.publicIPAddressVersion = value
    }

    /**
     * @param value The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("hcdrjwjxxohslomg")
    public suspend fun publicIPPrefix(`value`: Output<SubResourceArgs>) {
        this.publicIPPrefix = value
    }

    /**
     * @param value Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("gognrmfwekmucxqs")
    public suspend fun sku(`value`: Output<PublicIPAddressSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Specify what happens to the public IP when the VM is deleted
     */
    @JvmName("pnyekxahfmbgtgjt")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP when the VM is deleted
     */
    @JvmName("qopjrbyxhhqxkywu")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP when the VM is deleted
     */
    @JvmName("lavwitoioipixqeq")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("teaxgjcpqhewyuey")
    public suspend
    fun dnsSettings(`value`: VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("ygirvayhsqhrbaey")
    public suspend
    fun dnsSettings(argument: suspend VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("ahkqqmgwuqeqconx")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The list of IP tags associated with the public IP address.
     */
    @JvmName("pflgfchfricbupxi")
    public suspend fun ipTags(`value`: List<VirtualMachineScaleSetIpTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("xuuiwitxixmopgjr")
    public suspend
    fun ipTags(argument: List<suspend VirtualMachineScaleSetIpTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetIpTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("lmwddwhlejlsfmdw")
    public suspend fun ipTags(
        vararg
        argument: suspend VirtualMachineScaleSetIpTagArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetIpTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("ughkmxtafkbslmai")
    public suspend fun ipTags(argument: suspend VirtualMachineScaleSetIpTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetIpTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of IP tags associated with the public IP address.
     */
    @JvmName("wfyfplyvhtaktkuo")
    public suspend fun ipTags(vararg values: VirtualMachineScaleSetIpTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value The publicIP address configuration name.
     */
    @JvmName("nfpbomjamaffkubp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("qswvuwulanpexgdj")
    public suspend fun publicIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("qrgokrohgvrovqpr")
    public fun publicIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("guatnxiciwupjfue")
    public fun publicIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("kglprvngwlgijfly")
    public suspend fun publicIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefix = mapped
    }

    /**
     * @param argument The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("dquawiatcxwrmrrf")
    public suspend fun publicIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPPrefix = mapped
    }

    /**
     * @param value Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("qrynvcdqpsssrgbb")
    public suspend fun sku(`value`: PublicIPAddressSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("rrfkfxutnrdlyxgo")
    public suspend fun sku(argument: suspend PublicIPAddressSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): VirtualMachineScaleSetPublicIPAddressConfigurationArgs =
        VirtualMachineScaleSetPublicIPAddressConfigurationArgs(
            deleteOption = deleteOption,
            dnsSettings = dnsSettings,
            idleTimeoutInMinutes = idleTimeoutInMinutes,
            ipTags = ipTags,
            name = name ?: throw PulumiNullFieldException("name"),
            publicIPAddressVersion = publicIPAddressVersion,
            publicIPPrefix = publicIPPrefix,
            sku = sku,
        )
}
