@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskControllerTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set storage profile.
 * @property dataDisks Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property diskControllerType
 * @property imageReference Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
 * @property osDisk Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 */
public data class VirtualMachineScaleSetStorageProfileArgs(
    public val dataDisks: Output<List<VirtualMachineScaleSetDataDiskArgs>>? = null,
    public val diskControllerType: Output<List<Either<String, DiskControllerTypes>>>? = null,
    public val imageReference: Output<ImageReferenceArgs>? = null,
    public val osDisk: Output<VirtualMachineScaleSetOSDiskArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetStorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .diskControllerType(
                diskControllerType?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineScaleSetStorageProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetStorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<VirtualMachineScaleSetDataDiskArgs>>? = null

    private var diskControllerType: Output<List<Either<String, DiskControllerTypes>>>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var osDisk: Output<VirtualMachineScaleSetOSDiskArgs>? = null

    /**
     * @param value Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("wtmlakqkklcrankq")
    public suspend fun dataDisks(`value`: Output<List<VirtualMachineScaleSetDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("kpyqxbtwkhwylunu")
    public suspend fun dataDisks(vararg values: Output<VirtualMachineScaleSetDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("htvadlwkbamcfciq")
    public suspend fun dataDisks(values: List<Output<VirtualMachineScaleSetDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hwuswtbvektptclv")
    public suspend
    fun diskControllerType(`value`: Output<List<Either<String, DiskControllerTypes>>>) {
        this.diskControllerType = value
    }

    @JvmName("lnxqntusrtudgqgc")
    public suspend fun diskControllerType(
        vararg
        values: Output<Either<String, DiskControllerTypes>>,
    ) {
        this.diskControllerType = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ykahrkiljmsnlguo")
    public suspend fun diskControllerType(values: List<Output<Either<String, DiskControllerTypes>>>) {
        this.diskControllerType = Output.all(values)
    }

    /**
     * @param value Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("gtquiesoasyrpbau")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("pqnqfwdxbhooedtm")
    public suspend fun osDisk(`value`: Output<VirtualMachineScaleSetOSDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("qltaxfsklguaqirl")
    public suspend fun dataDisks(`value`: List<VirtualMachineScaleSetDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("hudajdwtfhhmigvt")
    public suspend
    fun dataDisks(argument: List<suspend VirtualMachineScaleSetDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("anemntcqwxnvxjnp")
    public suspend fun dataDisks(
        vararg
        argument: suspend VirtualMachineScaleSetDataDiskArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ymveusxllalgosjm")
    public suspend
    fun dataDisks(argument: suspend VirtualMachineScaleSetDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ueyvmsxqvgrcppas")
    public suspend fun dataDisks(vararg values: VirtualMachineScaleSetDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value
     */
    @JvmName("xlffxdctmsorxgwc")
    public suspend fun diskControllerType(`value`: List<Either<String, DiskControllerTypes>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskControllerType = mapped
    }

    /**
     * @param values
     */
    @JvmName("peytwadnfyjfqhrc")
    public suspend fun diskControllerType(vararg values: Either<String, DiskControllerTypes>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskControllerType = mapped
    }

    /**
     * @param value Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("ujcfmgkybbstagtn")
    public suspend fun imageReference(`value`: ImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("rjflpmxfaawclyxh")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("rqieqenkvjvqmgkq")
    public suspend fun osDisk(`value`: VirtualMachineScaleSetOSDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ipcrvpguctuttunx")
    public suspend fun osDisk(argument: suspend VirtualMachineScaleSetOSDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetOSDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    internal fun build(): VirtualMachineScaleSetStorageProfileArgs =
        VirtualMachineScaleSetStorageProfileArgs(
            dataDisks = dataDisks,
            diskControllerType = diskControllerType,
            imageReference = imageReference,
            osDisk = osDisk,
        )
}
