@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a capacity reservation that provides as snapshot of the runtime properties of the capacity reservation that is managed by the platform and can change outside of control plane operations.
 * @property statuses The resource status information.
 * @property utilizationInfo Unutilized capacity of the capacity reservation.
 */
public data class CapacityReservationInstanceViewResponse(
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val utilizationInfo: CapacityReservationUtilizationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CapacityReservationInstanceViewResponse):
            CapacityReservationInstanceViewResponse = CapacityReservationInstanceViewResponse(
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            utilizationInfo = javaType.utilizationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationUtilizationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
