@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data used when creating a disk.
 * @property createOption This enumerates the possible sources of a disk's creation.
 * @property galleryImageReference Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
 * @property imageReference Disk source information for PIR or user images.
 * @property logicalSectorSize Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
 * @property performancePlus Set this flag to true to get a boost on the performance target of the disk deployed, see here on the respective performance target. This flag can only be set on disk creation time and cannot be disabled after enabled.
 * @property securityDataUri If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
 * @property sourceResourceId If createOption is Copy, this is the ARM id of the source snapshot or disk.
 * @property sourceUniqueId If this field is set, this is the unique id identifying the source of this resource.
 * @property sourceUri If createOption is Import, this is the URI of a blob to be imported into a managed disk.
 * @property storageAccountId Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
 * @property uploadSizeBytes If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
 */
public data class CreationDataResponse(
    public val createOption: String,
    public val galleryImageReference: ImageDiskReferenceResponse? = null,
    public val imageReference: ImageDiskReferenceResponse? = null,
    public val logicalSectorSize: Int? = null,
    public val performancePlus: Boolean? = null,
    public val securityDataUri: String? = null,
    public val sourceResourceId: String? = null,
    public val sourceUniqueId: String,
    public val sourceUri: String? = null,
    public val storageAccountId: String? = null,
    public val uploadSizeBytes: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CreationDataResponse):
            CreationDataResponse = CreationDataResponse(
            createOption = javaType.createOption(),
            galleryImageReference = javaType.galleryImageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageDiskReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageReference = javaType.imageReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageDiskReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logicalSectorSize = javaType.logicalSectorSize().map({ args0 -> args0 }).orElse(null),
            performancePlus = javaType.performancePlus().map({ args0 -> args0 }).orElse(null),
            securityDataUri = javaType.securityDataUri().map({ args0 -> args0 }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            sourceUniqueId = javaType.sourceUniqueId(),
            sourceUri = javaType.sourceUri().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            uploadSizeBytes = javaType.uploadSizeBytes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
