@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the disk.
 * @property encryptionSettings Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
 * @property name The disk name.
 * @property statuses The resource status information.
 */
public data class DiskInstanceViewResponse(
    public val encryptionSettings: List<DiskEncryptionSettingsResponse>? = null,
    public val name: String? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskInstanceViewResponse):
            DiskInstanceViewResponse = DiskInstanceViewResponse(
            encryptionSettings = javaType.encryptionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskEncryptionSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
