@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The publishing profile of a gallery image Version.
 * @property endOfLifeDate The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
 * @property excludeFromLatest If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
 * @property publishedDate The timestamp for when the gallery image version is published.
 * @property replicaCount The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
 * @property replicationMode Optional parameter which specifies the mode to be used for replication. This property is not updatable.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 * @property targetExtendedLocations The target extended locations where the Image Version is going to be replicated to. This property is updatable.
 * @property targetRegions The target regions where the Image Version is going to be replicated to. This property is updatable.
 */
public data class GalleryImageVersionPublishingProfileResponse(
    public val endOfLifeDate: String? = null,
    public val excludeFromLatest: Boolean? = null,
    public val publishedDate: String,
    public val replicaCount: Int? = null,
    public val replicationMode: String? = null,
    public val storageAccountType: String? = null,
    public val targetExtendedLocations: List<GalleryTargetExtendedLocationResponse>? = null,
    public val targetRegions: List<TargetRegionResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryImageVersionPublishingProfileResponse):
            GalleryImageVersionPublishingProfileResponse = GalleryImageVersionPublishingProfileResponse(
            endOfLifeDate = javaType.endOfLifeDate().map({ args0 -> args0 }).orElse(null),
            excludeFromLatest = javaType.excludeFromLatest().map({ args0 -> args0 }).orElse(null),
            publishedDate = javaType.publishedDate(),
            replicaCount = javaType.replicaCount().map({ args0 -> args0 }).orElse(null),
            replicationMode = javaType.replicationMode().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
            targetExtendedLocations = javaType.targetExtendedLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryTargetExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }),
            targetRegions = javaType.targetRegions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.TargetRegionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
