@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * This is the OS disk image.
 * @property hostCaching The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
 * @property sizeInGB This property indicates the size of the VHD to be created.
 * @property source The source for the disk image.
 */
public data class GalleryOSDiskImageResponse(
    public val hostCaching: String? = null,
    public val sizeInGB: Int,
    public val source: GalleryDiskImageSourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryOSDiskImageResponse):
            GalleryOSDiskImageResponse = GalleryOSDiskImageResponse(
            hostCaching = javaType.hostCaching().map({ args0 -> args0 }).orElse(null),
            sizeInGB = javaType.sizeInGB(),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryDiskImageSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
