@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
 * @property additionalCapabilities Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
 * @property hosts A list of references to all dedicated hosts in the dedicated host group.
 * @property id Resource Id
 * @property instanceView The dedicated host group instance view, which has the list of instance view of the dedicated hosts under the dedicated host group.
 * @property location Resource location
 * @property name Resource name
 * @property platformFaultDomainCount Number of fault domains that the host group can span.
 * @property supportAutomaticPlacement Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
 * @property tags Resource tags
 * @property type Resource type
 * @property zones Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
 */
public data class GetDedicatedHostGroupResult(
    public val additionalCapabilities: DedicatedHostGroupPropertiesResponseAdditionalCapabilities? =
        null,
    public val hosts: List<SubResourceReadOnlyResponse>,
    public val id: String,
    public val instanceView: DedicatedHostGroupInstanceViewResponse,
    public val location: String,
    public val name: String,
    public val platformFaultDomainCount: Int,
    public val supportAutomaticPlacement: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDedicatedHostGroupResult):
            GetDedicatedHostGroupResult = GetDedicatedHostGroupResult(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupPropertiesResponseAdditionalCapabilities.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hosts = javaType.hosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupInstanceViewResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            platformFaultDomainCount = javaType.platformFaultDomainCount(),
            supportAutomaticPlacement = javaType.supportAutomaticPlacement().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
