@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * disk encryption set resource.
 * @property activeKey The key vault key which is currently used by this disk encryption set.
 * @property autoKeyRotationError The error that was encountered during auto-key rotation. If an error is present, then auto-key rotation will not be attempted until the error on this disk encryption set is fixed.
 * @property encryptionType The type of key used to encrypt the data of the disk.
 * @property federatedClientId Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the property.
 * @property id Resource Id
 * @property identity The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
 * @property lastKeyRotationTimestamp The time when the active key of this disk encryption set was updated.
 * @property location Resource location
 * @property name Resource name
 * @property previousKeys A readonly collection of key vault keys previously used by this disk encryption set while a key rotation is in progress. It will be empty if there is no ongoing key rotation.
 * @property provisioningState The disk encryption set provisioning state.
 * @property rotationToLatestKeyVersionEnabled Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetDiskEncryptionSetResult(
    public val activeKey: KeyForDiskEncryptionSetResponse? = null,
    public val autoKeyRotationError: ApiErrorResponse,
    public val encryptionType: String? = null,
    public val federatedClientId: String? = null,
    public val id: String,
    public val identity: EncryptionSetIdentityResponse? = null,
    public val lastKeyRotationTimestamp: String,
    public val location: String,
    public val name: String,
    public val previousKeys: List<KeyForDiskEncryptionSetResponse>,
    public val provisioningState: String,
    public val rotationToLatestKeyVersionEnabled: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetDiskEncryptionSetResult):
            GetDiskEncryptionSetResult = GetDiskEncryptionSetResult(
            activeKey = javaType.activeKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyForDiskEncryptionSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoKeyRotationError = javaType.autoKeyRotationError().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorResponse.Companion.toKotlin(args0)
            }),
            encryptionType = javaType.encryptionType().map({ args0 -> args0 }).orElse(null),
            federatedClientId = javaType.federatedClientId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSetIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastKeyRotationTimestamp = javaType.lastKeyRotationTimestamp(),
            location = javaType.location(),
            name = javaType.name(),
            previousKeys = javaType.previousKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyForDiskEncryptionSetResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            rotationToLatestKeyVersionEnabled = javaType.rotationToLatestKeyVersionEnabled().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
