@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies information about the gallery Application Version that you want to create or update.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property publishingProfile The publishing profile of a gallery image version.
 * @property replicationStatus This is the replication status of the gallery image version.
 * @property safetyProfile The safety profile of the Gallery Application Version.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGalleryApplicationVersionResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val publishingProfile: GalleryApplicationVersionPublishingProfileResponse,
    public val replicationStatus: ReplicationStatusResponse,
    public val safetyProfile: GalleryApplicationVersionSafetyProfileResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetGalleryApplicationVersionResult):
            GetGalleryApplicationVersionResult = GetGalleryApplicationVersionResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publishingProfile = javaType.publishingProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionPublishingProfileResponse.Companion.toKotlin(args0)
            }),
            replicationStatus = javaType.replicationStatus().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse.Companion.toKotlin(args0)
            }),
            safetyProfile = javaType.safetyProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationVersionSafetyProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
