@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies information about the SSH public key.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property publicKey SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetSshPublicKeyResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val publicKey: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetSshPublicKeyResult):
            GetSshPublicKeyResult = GetSshPublicKeyResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
