@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the disk for which update is pending.
 * @property targetTier The target performance tier of the disk if a tier change operation is in progress.
 */
public data class PropertyUpdatesInProgressResponse(
    public val targetTier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PropertyUpdatesInProgressResponse):
            PropertyUpdatesInProgressResponse = PropertyUpdatesInProgressResponse(
            targetTier = javaType.targetTier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
