@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Describes the resource range.
 * @property max The maximum number of the resource.
 * @property min The minimum number of the resource.
 */
public data class ResourceRangeResponse(
    public val max: Int? = null,
    public val min: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ResourceRangeResponse):
            ResourceRangeResponse = ResourceRangeResponse(
            max = javaType.max().map({ args0 -> args0 }).orElse(null),
            min = javaType.min().map({ args0 -> args0 }).orElse(null),
        )
    }
}
