@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Group of the gallery sharing profile
 * @property ids A list of subscription/tenant ids the gallery is aimed to be shared to.
 * @property type This property allows you to specify the type of sharing group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br> **AADTenants**
 */
public data class SharingProfileGroupResponse(
    public val ids: List<String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SharingProfileGroupResponse):
            SharingProfileGroupResponse = SharingProfileGroupResponse(
            ids = javaType.ids().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
