@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Sharing status of current gallery.
 * @property aggregatedState Aggregated sharing state of current gallery.
 * @property summary Summary of all regional sharing status.
 */
public data class SharingStatusResponse(
    public val aggregatedState: String,
    public val summary: List<RegionalSharingStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SharingStatusResponse):
            SharingStatusResponse = SharingStatusResponse(
            aggregatedState = javaType.aggregatedState(),
            summary = javaType.summary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RegionalSharingStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
