@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
 * @property vTpmEnabled Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
 */
public data class UefiSettingsResponse(
    public val secureBootEnabled: Boolean? = null,
    public val vTpmEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.UefiSettingsResponse):
            UefiSettingsResponse = UefiSettingsResponse(
            secureBootEnabled = javaType.secureBootEnabled().map({ args0 -> args0 }).orElse(null),
            vTpmEnabled = javaType.vTpmEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
