@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a virtual machine.
 * @property assignedHost Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. Minimum api-version: 2020-06-01.
 * @property bootDiagnostics Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 * @property computerName The computer name assigned to the virtual machine.
 * @property disks The virtual machine disk information.
 * @property extensions The extensions information.
 * @property hyperVGeneration Specifies the HyperVGeneration Type associated with a resource
 * @property maintenanceRedeployStatus The Maintenance Operation status on the virtual machine.
 * @property osName The Operating System running on the virtual machine.
 * @property osVersion The version of Operating System running on the virtual machine.
 * @property patchStatus [Preview Feature] The status of virtual machine patch operations.
 * @property platformFaultDomain Specifies the fault domain of the virtual machine.
 * @property platformUpdateDomain Specifies the update domain of the virtual machine.
 * @property rdpThumbPrint The Remote desktop certificate thumbprint.
 * @property statuses The resource status information.
 * @property vmAgent The VM Agent running on the virtual machine.
 * @property vmHealth The health status for the VM.
 */
public data class VirtualMachineInstanceViewResponse(
    public val assignedHost: String,
    public val bootDiagnostics: BootDiagnosticsInstanceViewResponse? = null,
    public val computerName: String? = null,
    public val disks: List<DiskInstanceViewResponse>? = null,
    public val extensions: List<VirtualMachineExtensionInstanceViewResponse>? = null,
    public val hyperVGeneration: String? = null,
    public val maintenanceRedeployStatus: MaintenanceRedeployStatusResponse? = null,
    public val osName: String? = null,
    public val osVersion: String? = null,
    public val patchStatus: VirtualMachinePatchStatusResponse? = null,
    public val platformFaultDomain: Int? = null,
    public val platformUpdateDomain: Int? = null,
    public val rdpThumbPrint: String? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val vmAgent: VirtualMachineAgentInstanceViewResponse? = null,
    public val vmHealth: VirtualMachineHealthStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineInstanceViewResponse):
            VirtualMachineInstanceViewResponse = VirtualMachineInstanceViewResponse(
            assignedHost = javaType.assignedHost(),
            bootDiagnostics = javaType.bootDiagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.BootDiagnosticsInstanceViewResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            maintenanceRedeployStatus = javaType.maintenanceRedeployStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.MaintenanceRedeployStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osName = javaType.osName().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            patchStatus = javaType.patchStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachinePatchStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            platformFaultDomain = javaType.platformFaultDomain().map({ args0 -> args0 }).orElse(null),
            platformUpdateDomain = javaType.platformUpdateDomain().map({ args0 -> args0 }).orElse(null),
            rdpThumbPrint = javaType.rdpThumbPrint().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            vmAgent = javaType.vmAgent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineAgentInstanceViewResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmHealth = javaType.vmHealth().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineHealthStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
