@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set network profile.
 * @property healthProbe A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
 * @property networkApiVersion specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
 * @property networkInterfaceConfigurations The list of network configurations.
 */
public data class VirtualMachineScaleSetNetworkProfileResponse(
    public val healthProbe: ApiEntityReferenceResponse? = null,
    public val networkApiVersion: String? = null,
    public val networkInterfaceConfigurations:
    List<VirtualMachineScaleSetNetworkConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetNetworkProfileResponse):
            VirtualMachineScaleSetNetworkProfileResponse = VirtualMachineScaleSetNetworkProfileResponse(
            healthProbe = javaType.healthProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkApiVersion = javaType.networkApiVersion().map({ args0 -> args0 }).orElse(null),
            networkInterfaceConfigurations = javaType.networkInterfaceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
