@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a virtual machine scale set VM.
 * @property assignedHost Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when the virtual machine is associated with a dedicated host group that has automatic placement enabled. Minimum api-version: 2020-06-01.
 * @property bootDiagnostics Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 * @property computerName Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
 * @property disks The disks information.
 * @property extensions The extensions information.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property maintenanceRedeployStatus The Maintenance Operation status on the virtual machine.
 * @property osName The Operating System running on the hybrid machine.
 * @property osVersion The version of Operating System running on the hybrid machine.
 * @property placementGroupId The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
 * @property platformFaultDomain The Fault Domain count.
 * @property platformUpdateDomain The Update Domain count.
 * @property rdpThumbPrint The Remote desktop certificate thumbprint.
 * @property statuses The resource status information.
 * @property vmAgent The VM Agent running on the virtual machine.
 * @property vmHealth The health status for the VM.
 */
public data class VirtualMachineScaleSetVMInstanceViewResponse(
    public val assignedHost: String,
    public val bootDiagnostics: BootDiagnosticsInstanceViewResponse? = null,
    public val computerName: String? = null,
    public val disks: List<DiskInstanceViewResponse>? = null,
    public val extensions: List<VirtualMachineExtensionInstanceViewResponse>? = null,
    public val hyperVGeneration: String? = null,
    public val maintenanceRedeployStatus: MaintenanceRedeployStatusResponse? = null,
    public val osName: String? = null,
    public val osVersion: String? = null,
    public val placementGroupId: String? = null,
    public val platformFaultDomain: Int? = null,
    public val platformUpdateDomain: Int? = null,
    public val rdpThumbPrint: String? = null,
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val vmAgent: VirtualMachineAgentInstanceViewResponse? = null,
    public val vmHealth: VirtualMachineHealthStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetVMInstanceViewResponse):
            VirtualMachineScaleSetVMInstanceViewResponse = VirtualMachineScaleSetVMInstanceViewResponse(
            assignedHost = javaType.assignedHost(),
            bootDiagnostics = javaType.bootDiagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.BootDiagnosticsInstanceViewResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            maintenanceRedeployStatus = javaType.maintenanceRedeployStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.MaintenanceRedeployStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osName = javaType.osName().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            placementGroupId = javaType.placementGroupId().map({ args0 -> args0 }).orElse(null),
            platformFaultDomain = javaType.platformFaultDomain().map({ args0 -> args0 }).orElse(null),
            platformUpdateDomain = javaType.platformUpdateDomain().map({ args0 -> args0 }).orElse(null),
            rdpThumbPrint = javaType.rdpThumbPrint().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            vmAgent = javaType.vmAgent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineAgentInstanceViewResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmHealth = javaType.vmHealth().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineHealthStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
