@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin

import com.pulumi.azurenative.confidentialledger.LedgerArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.LedgerPropertiesArgs
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.LedgerPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Confidential Ledger. Contains the properties of Confidential Ledger Resource.
 * Azure REST API version: 2022-05-13. Prior API version in Azure Native 1.x: 2020-12-01-preview.
 * Other available API versions: 2023-01-26-preview, 2023-06-28-preview.
 * ## Example Usage
 * ### ConfidentialLedgerCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ledger = new AzureNative.ConfidentialLedger.Ledger("ledger", new()
 *     {
 *         LedgerName = "DummyLedgerName",
 *         Location = "EastUS",
 *         Properties = new AzureNative.ConfidentialLedger.Inputs.LedgerPropertiesArgs
 *         {
 *             AadBasedSecurityPrincipals = new[]
 *             {
 *                 new AzureNative.ConfidentialLedger.Inputs.AADBasedSecurityPrincipalArgs
 *                 {
 *                     LedgerRoleName = "Administrator",
 *                     PrincipalId = "34621747-6fc8-4771-a2eb-72f31c461f2e",
 *                     TenantId = "bce123b9-2b7b-4975-8360-5ca0b9b1cd08",
 *                 },
 *             },
 *             CertBasedSecurityPrincipals = new[]
 *             {
 *                 new AzureNative.ConfidentialLedger.Inputs.CertBasedSecurityPrincipalArgs
 *                 {
 *                     Cert = "-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----",
 *                     LedgerRoleName = "Reader",
 *                 },
 *             },
 *             LedgerType = "Public",
 *         },
 *         ResourceGroupName = "DummyResourceGroupName",
 *         Tags =
 *         {
 *             { "additionalProps1", "additional properties" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/confidentialledger/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := confidentialledger.NewLedger(ctx, "ledger", &confidentialledger.LedgerArgs{
 * 			LedgerName: pulumi.String("DummyLedgerName"),
 * 			Location:   pulumi.String("EastUS"),
 * 			Properties: confidentialledger.LedgerPropertiesResponse{
 * 				AadBasedSecurityPrincipals: confidentialledger.AADBasedSecurityPrincipalArray{
 * 					&confidentialledger.AADBasedSecurityPrincipalArgs{
 * 						LedgerRoleName: pulumi.String("Administrator"),
 * 						PrincipalId:    pulumi.String("34621747-6fc8-4771-a2eb-72f31c461f2e"),
 * 						TenantId:       pulumi.String("bce123b9-2b7b-4975-8360-5ca0b9b1cd08"),
 * 					},
 * 				},
 * 				CertBasedSecurityPrincipals: confidentialledger.CertBasedSecurityPrincipalArray{
 * 					&confidentialledger.CertBasedSecurityPrincipalArgs{
 * 						Cert:           pulumi.String("-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----"),
 * 						LedgerRoleName: pulumi.String("Reader"),
 * 					},
 * 				},
 * 				LedgerType: pulumi.String("Public"),
 * 			},
 * 			ResourceGroupName: pulumi.String("DummyResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProps1": pulumi.String("additional properties"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.confidentialledger.Ledger;
 * import com.pulumi.azurenative.confidentialledger.LedgerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ledger = new Ledger("ledger", LedgerArgs.builder()
 *             .ledgerName("DummyLedgerName")
 *             .location("EastUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("aadBasedSecurityPrincipals", Map.ofEntries(
 *                     Map.entry("ledgerRoleName", "Administrator"),
 *                     Map.entry("principalId", "34621747-6fc8-4771-a2eb-72f31c461f2e"),
 *                     Map.entry("tenantId", "bce123b9-2b7b-4975-8360-5ca0b9b1cd08")
 *                 )),
 *                 Map.entry("certBasedSecurityPrincipals", Map.ofEntries(
 *                     Map.entry("cert", "-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----"),
 *                     Map.entry("ledgerRoleName", "Reader")
 *                 )),
 *                 Map.entry("ledgerType", "Public")
 *             ))
 *             .resourceGroupName("DummyResourceGroupName")
 *             .tags(Map.of("additionalProps1", "additional properties"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confidentialledger:Ledger DummyLedgerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}
 * ```
 * @property ledgerName Name of the Confidential Ledger
 * @property location The Azure location where the Confidential Ledger is running.
 * @property properties Properties of Confidential Ledger Resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags Additional tags for Confidential Ledger
 */
public data class LedgerArgs(
    public val ledgerName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<LedgerPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.LedgerArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.LedgerArgs =
        com.pulumi.azurenative.confidentialledger.LedgerArgs.builder()
            .ledgerName(ledgerName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LedgerArgs].
 */
@PulumiTagMarker
public class LedgerArgsBuilder internal constructor() {
    private var ledgerName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<LedgerPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Confidential Ledger
     */
    @JvmName("yrvmmsppqantgair")
    public suspend fun ledgerName(`value`: Output<String>) {
        this.ledgerName = value
    }

    /**
     * @param value The Azure location where the Confidential Ledger is running.
     */
    @JvmName("glgrupueqnluedpy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Confidential Ledger Resource.
     */
    @JvmName("tmiwqghbimlugbyx")
    public suspend fun properties(`value`: Output<LedgerPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kakyorsjjbdqvxos")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Additional tags for Confidential Ledger
     */
    @JvmName("rutypmhaawpiqxlx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Confidential Ledger
     */
    @JvmName("piiibrmtxetfhuvy")
    public suspend fun ledgerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ledgerName = mapped
    }

    /**
     * @param value The Azure location where the Confidential Ledger is running.
     */
    @JvmName("ckdntrbnlqlmwlda")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Confidential Ledger Resource.
     */
    @JvmName("rwexejqmqqlebwnm")
    public suspend fun properties(`value`: LedgerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Confidential Ledger Resource.
     */
    @JvmName("xqnecjvssxfsxqlg")
    public suspend fun properties(argument: suspend LedgerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LedgerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lccyvqyvmruvgaxe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Additional tags for Confidential Ledger
     */
    @JvmName("clcquulwuawfgumu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Additional tags for Confidential Ledger
     */
    @JvmName("shomcniakaamwexj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LedgerArgs = LedgerArgs(
        ledgerName = ledgerName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
