@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.DeploymentTypeArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.enums.LanguageRuntime
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Object representing DeploymentType for Managed CCF.
 * @property appSourceUri Source Uri containing ManagedCCF code
 * @property languageRuntime Unique name for the Managed CCF.
 */
public data class DeploymentTypeArgs(
    public val appSourceUri: Output<String>? = null,
    public val languageRuntime: Output<Either<String, LanguageRuntime>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.DeploymentTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.DeploymentTypeArgs =
        com.pulumi.azurenative.confidentialledger.inputs.DeploymentTypeArgs.builder()
            .appSourceUri(appSourceUri?.applyValue({ args0 -> args0 }))
            .languageRuntime(
                languageRuntime?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentTypeArgs].
 */
@PulumiTagMarker
public class DeploymentTypeArgsBuilder internal constructor() {
    private var appSourceUri: Output<String>? = null

    private var languageRuntime: Output<Either<String, LanguageRuntime>>? = null

    /**
     * @param value Source Uri containing ManagedCCF code
     */
    @JvmName("hmsludacsgmwcufq")
    public suspend fun appSourceUri(`value`: Output<String>) {
        this.appSourceUri = value
    }

    /**
     * @param value Unique name for the Managed CCF.
     */
    @JvmName("qsijouankrxkxipt")
    public suspend fun languageRuntime(`value`: Output<Either<String, LanguageRuntime>>) {
        this.languageRuntime = value
    }

    /**
     * @param value Source Uri containing ManagedCCF code
     */
    @JvmName("wgaqqwnbscdhvywi")
    public suspend fun appSourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSourceUri = mapped
    }

    /**
     * @param value Unique name for the Managed CCF.
     */
    @JvmName("tcftkxnvtpbdoogu")
    public suspend fun languageRuntime(`value`: Either<String, LanguageRuntime>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageRuntime = mapped
    }

    /**
     * @param value Unique name for the Managed CCF.
     */
    @JvmName("nessgfnowijqjblc")
    public fun languageRuntime(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LanguageRuntime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageRuntime = mapped
    }

    /**
     * @param value Unique name for the Managed CCF.
     */
    @JvmName("qnywklgbpldrldej")
    public fun languageRuntime(`value`: LanguageRuntime) {
        val toBeMapped = Either.ofRight<String, LanguageRuntime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageRuntime = mapped
    }

    internal fun build(): DeploymentTypeArgs = DeploymentTypeArgs(
        appSourceUri = appSourceUri,
        languageRuntime = languageRuntime,
    )
}
