@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.MemberIdentityCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Object representing MemberIdentityCertificate for Managed CCF.
 * @property certificate Member Identity Certificate
 * @property encryptionkey Member Identity Certificate Encryption Key
 * @property tags
 */
public data class MemberIdentityCertificateArgs(
    public val certificate: Output<String>? = null,
    public val encryptionkey: Output<String>? = null,
    public val tags: Output<List<CertificateTagsArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.MemberIdentityCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.confidentialledger.inputs.MemberIdentityCertificateArgs =
        com.pulumi.azurenative.confidentialledger.inputs.MemberIdentityCertificateArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .encryptionkey(encryptionkey?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MemberIdentityCertificateArgs].
 */
@PulumiTagMarker
public class MemberIdentityCertificateArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var encryptionkey: Output<String>? = null

    private var tags: Output<List<CertificateTagsArgs>>? = null

    /**
     * @param value Member Identity Certificate
     */
    @JvmName("fbobxebsubrfiwdd")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Member Identity Certificate Encryption Key
     */
    @JvmName("poghasrxmmqxkipl")
    public suspend fun encryptionkey(`value`: Output<String>) {
        this.encryptionkey = value
    }

    /**
     * @param value
     */
    @JvmName("jurncnvayjojrccf")
    public suspend fun tags(`value`: Output<List<CertificateTagsArgs>>) {
        this.tags = value
    }

    @JvmName("pfmdvaeaernkubtj")
    public suspend fun tags(vararg values: Output<CertificateTagsArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fmrjvqtoanfsycqi")
    public suspend fun tags(values: List<Output<CertificateTagsArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Member Identity Certificate
     */
    @JvmName("yplayffgpdecfyub")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Member Identity Certificate Encryption Key
     */
    @JvmName("xvbxtbotnprtbqno")
    public suspend fun encryptionkey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionkey = mapped
    }

    /**
     * @param value
     */
    @JvmName("noeuycjdddcydrmv")
    public suspend fun tags(`value`: List<CertificateTagsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument
     */
    @JvmName("akdmkvdajdknhacv")
    public suspend fun tags(argument: List<suspend CertificateTagsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CertificateTagsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mjduticcxueoajkj")
    public suspend fun tags(vararg argument: suspend CertificateTagsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CertificateTagsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dhjhcisupbvlcote")
    public suspend fun tags(argument: suspend CertificateTagsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateTagsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("bdrqukihqjqhibmo")
    public suspend fun tags(vararg values: CertificateTagsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MemberIdentityCertificateArgs = MemberIdentityCertificateArgs(
        certificate = certificate,
        encryptionkey = encryptionkey,
        tags = tags,
    )
}
