@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Tags for Managed CCF Certificates
 * @property tags Additional tags for Managed CCF Certificates
 */
public data class CertificateTagsResponse(
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.CertificateTagsResponse):
            CertificateTagsResponse = CertificateTagsResponse(
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
