@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.inputs

import com.pulumi.azurenative.confluent.inputs.UserDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subscriber detail
 * @property emailAddress Email address
 * @property firstName First name
 * @property lastName Last name
 */
public data class UserDetailArgs(
    public val emailAddress: Output<String>,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confluent.inputs.UserDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.confluent.inputs.UserDetailArgs =
        com.pulumi.azurenative.confluent.inputs.UserDetailArgs.builder()
            .emailAddress(emailAddress.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserDetailArgs].
 */
@PulumiTagMarker
public class UserDetailArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    /**
     * @param value Email address
     */
    @JvmName("mvmqnjcqkqswgssq")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value First name
     */
    @JvmName("geeikpfmljrdxmme")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last name
     */
    @JvmName("sruivrejgcvecmoh")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Email address
     */
    @JvmName("dujvnbdhjmabklpi")
    public suspend fun emailAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value First name
     */
    @JvmName("cpmqlesaqrwvemid")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last name
     */
    @JvmName("uwcbfppeogxyvebv")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    internal fun build(): UserDetailArgs = UserDetailArgs(
        emailAddress = emailAddress ?: throw PulumiNullFieldException("emailAddress"),
        firstName = firstName,
        lastName = lastName,
    )
}
