@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The environment to which cluster belongs
 * @property environment Environment of the referred resource
 * @property id ID of the referred resource
 * @property related API URL for accessing or modifying the referred object
 * @property resourceName CRN reference to the referred resource
 */
public data class ClusterEnvironmentEntityResponse(
    public val environment: String? = null,
    public val id: String? = null,
    public val related: String? = null,
    public val resourceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ClusterEnvironmentEntityResponse):
            ClusterEnvironmentEntityResponse = ClusterEnvironmentEntityResponse(
            environment = javaType.environment().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            related = javaType.related().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
