@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Status of the cluster record
 * @property cku The number of Confluent Kafka Units
 * @property phase The lifecycle phase of the cluster
 */
public data class ClusterStatusEntityResponse(
    public val cku: Int? = null,
    public val phase: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ClusterStatusEntityResponse):
            ClusterStatusEntityResponse = ClusterStatusEntityResponse(
            cku = javaType.cku().map({ args0 -> args0 }).orElse(null),
            phase = javaType.phase().map({ args0 -> args0 }).orElse(null),
        )
    }
}
