@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Metadata of the list
 * @property first First page of the list
 * @property last Last page of the list
 * @property next Next page of the list
 * @property prev Previous page of the list
 * @property totalSize Total size of the list
 */
public data class ConfluentListMetadataResponse(
    public val first: String? = null,
    public val last: String? = null,
    public val next: String? = null,
    public val prev: String? = null,
    public val totalSize: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ConfluentListMetadataResponse):
            ConfluentListMetadataResponse = ConfluentListMetadataResponse(
            first = javaType.first().map({ args0 -> args0 }).orElse(null),
            last = javaType.last().map({ args0 -> args0 }).orElse(null),
            next = javaType.next().map({ args0 -> args0 }).orElse(null),
            prev = javaType.prev().map({ args0 -> args0 }).orElse(null),
            totalSize = javaType.totalSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
