@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getClusterPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getDatastorePlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getGuestAgentPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getHostPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getHybridIdentityMetadatumPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getInventoryItemPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getMachineExtensionPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getResourcePoolPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVCenterPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVMInstanceGuestAgentPlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVirtualMachineInstancePlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVirtualMachineTemplatePlain
import com.pulumi.azurenative.connectedvmwarevsphere.ConnectedvmwarevsphereFunctions.getVirtualNetworkPlain
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetDatastorePlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetDatastorePlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetGuestAgentPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetGuestAgentPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetHostPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetHostPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetHybridIdentityMetadatumPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetHybridIdentityMetadatumPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetInventoryItemPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetInventoryItemPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetMachineExtensionPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetMachineExtensionPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetResourcePoolPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetResourcePoolPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVCenterPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVCenterPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVMInstanceGuestAgentPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVMInstanceGuestAgentPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachineInstancePlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachineInstancePlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachineTemplatePlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualMachineTemplatePlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualNetworkPlainArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GetVirtualNetworkPlainArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetDatastoreResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetGuestAgentResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetHostResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetHybridIdentityMetadatumResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetInventoryItemResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetMachineExtensionResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetResourcePoolResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVCenterResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVMInstanceGuestAgentResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineInstanceResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineTemplateResult
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualNetworkResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetDatastoreResult.Companion.toKotlin as getDatastoreResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetGuestAgentResult.Companion.toKotlin as getGuestAgentResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetHostResult.Companion.toKotlin as getHostResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetHybridIdentityMetadatumResult.Companion.toKotlin as getHybridIdentityMetadatumResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetInventoryItemResult.Companion.toKotlin as getInventoryItemResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetMachineExtensionResult.Companion.toKotlin as getMachineExtensionResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetResourcePoolResult.Companion.toKotlin as getResourcePoolResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVCenterResult.Companion.toKotlin as getVCenterResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVMInstanceGuestAgentResult.Companion.toKotlin as getVMInstanceGuestAgentResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineInstanceResult.Companion.toKotlin as getVirtualMachineInstanceResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualMachineTemplateResult.Companion.toKotlin as getVirtualMachineTemplateResultToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GetVirtualNetworkResult.Companion.toKotlin as getVirtualNetworkResultToKotlin

public object ConnectedvmwarevsphereFunctions {
    /**
     * Implements cluster GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the cluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the cluster.
     * @param resourceGroupName The Resource Group Name.
     * @return Define the cluster.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return Define the cluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements datastore GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the datastore.
     */
    public suspend fun getDatastore(argument: GetDatastorePlainArgs): GetDatastoreResult =
        getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())

    /**
     * @see [getDatastore].
     * @param datastoreName Name of the datastore.
     * @param resourceGroupName The Resource Group Name.
     * @return Define the datastore.
     */
    public suspend fun getDatastore(datastoreName: String, resourceGroupName: String):
        GetDatastoreResult {
        val argument = GetDatastorePlainArgs(
            datastoreName = datastoreName,
            resourceGroupName = resourceGroupName,
        )
        return getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatastore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetDatastorePlainArgs].
     * @return Define the datastore.
     */
    public suspend fun getDatastore(argument: suspend GetDatastorePlainArgsBuilder.() -> Unit):
        GetDatastoreResult {
        val builder = GetDatastorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatastoreResultToKotlin(getDatastorePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements GuestAgent GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview.
     * @param argument null
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: GetGuestAgentPlainArgs): GetGuestAgentResult =
        getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())

    /**
     * @see [getGuestAgent].
     * @param name Name of the GuestAgent.
     * @param resourceGroupName The Resource Group Name.
     * @param virtualMachineName Name of the vm.
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(
        name: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetGuestAgentResult {
        val argument = GetGuestAgentPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getGuestAgentResultToKotlin(getGuestAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetGuestAgentPlainArgs].
     * @return Defines the GuestAgent.
     */
    public suspend fun getGuestAgent(argument: suspend GetGuestAgentPlainArgsBuilder.() -> Unit):
        GetGuestAgentResult {
        val builder = GetGuestAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestAgentResultToKotlin(getGuestAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements host GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the host.
     */
    public suspend fun getHost(argument: GetHostPlainArgs): GetHostResult =
        getHostResultToKotlin(getHostPlain(argument.toJava()).await())

    /**
     * @see [getHost].
     * @param hostName Name of the host.
     * @param resourceGroupName The Resource Group Name.
     * @return Define the host.
     */
    public suspend fun getHost(hostName: String, resourceGroupName: String): GetHostResult {
        val argument = GetHostPlainArgs(
            hostName = hostName,
            resourceGroupName = resourceGroupName,
        )
        return getHostResultToKotlin(getHostPlain(argument.toJava()).await())
    }

    /**
     * @see [getHost].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetHostPlainArgs].
     * @return Define the host.
     */
    public suspend fun getHost(argument: suspend GetHostPlainArgsBuilder.() -> Unit): GetHostResult {
        val builder = GetHostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostResultToKotlin(getHostPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements HybridIdentityMetadata GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview.
     * @param argument null
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(argument: GetHybridIdentityMetadatumPlainArgs):
        GetHybridIdentityMetadatumResult =
        getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())

    /**
     * @see [getHybridIdentityMetadatum].
     * @param metadataName Name of the HybridIdentityMetadata.
     * @param resourceGroupName The Resource Group Name.
     * @param virtualMachineName Name of the vm.
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(
        metadataName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetHybridIdentityMetadatumResult {
        val argument = GetHybridIdentityMetadatumPlainArgs(
            metadataName = metadataName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridIdentityMetadatum].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetHybridIdentityMetadatumPlainArgs].
     * @return Defines the HybridIdentityMetadata.
     */
    public suspend
    fun getHybridIdentityMetadatum(argument: suspend GetHybridIdentityMetadatumPlainArgsBuilder.() -> Unit):
        GetHybridIdentityMetadatumResult {
        val builder = GetHybridIdentityMetadatumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements InventoryItem GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Defines the inventory item.
     */
    public suspend fun getInventoryItem(argument: GetInventoryItemPlainArgs): GetInventoryItemResult =
        getInventoryItemResultToKotlin(getInventoryItemPlain(argument.toJava()).await())

    /**
     * @see [getInventoryItem].
     * @param inventoryItemName Name of the inventoryItem.
     * @param resourceGroupName The Resource Group Name.
     * @param vcenterName Name of the vCenter.
     * @return Defines the inventory item.
     */
    public suspend fun getInventoryItem(
        inventoryItemName: String,
        resourceGroupName: String,
        vcenterName: String,
    ): GetInventoryItemResult {
        val argument = GetInventoryItemPlainArgs(
            inventoryItemName = inventoryItemName,
            resourceGroupName = resourceGroupName,
            vcenterName = vcenterName,
        )
        return getInventoryItemResultToKotlin(getInventoryItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getInventoryItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetInventoryItemPlainArgs].
     * @return Defines the inventory item.
     */
    public suspend
    fun getInventoryItem(argument: suspend GetInventoryItemPlainArgsBuilder.() -> Unit):
        GetInventoryItemResult {
        val builder = GetInventoryItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInventoryItemResultToKotlin(getInventoryItemPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2022-01-10-preview, 2023-03-01-preview.
     * @param argument null
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(argument: GetMachineExtensionPlainArgs):
        GetMachineExtensionResult =
        getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())

    /**
     * @see [getMachineExtension].
     * @param extensionName The name of the machine extension.
     * @param resourceGroupName The Resource Group Name.
     * @param virtualMachineName The name of the machine containing the extension.
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(
        extensionName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetMachineExtensionResult {
        val argument = GetMachineExtensionPlainArgs(
            extensionName = extensionName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetMachineExtensionPlainArgs].
     * @return Describes a Machine Extension.
     */
    public suspend
    fun getMachineExtension(argument: suspend GetMachineExtensionPlainArgsBuilder.() -> Unit):
        GetMachineExtensionResult {
        val builder = GetMachineExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements resourcePool GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the resourcePool.
     */
    public suspend fun getResourcePool(argument: GetResourcePoolPlainArgs): GetResourcePoolResult =
        getResourcePoolResultToKotlin(getResourcePoolPlain(argument.toJava()).await())

    /**
     * @see [getResourcePool].
     * @param resourceGroupName The Resource Group Name.
     * @param resourcePoolName Name of the resourcePool.
     * @return Define the resourcePool.
     */
    public suspend fun getResourcePool(resourceGroupName: String, resourcePoolName: String):
        GetResourcePoolResult {
        val argument = GetResourcePoolPlainArgs(
            resourceGroupName = resourceGroupName,
            resourcePoolName = resourcePoolName,
        )
        return getResourcePoolResultToKotlin(getResourcePoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourcePool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetResourcePoolPlainArgs].
     * @return Define the resourcePool.
     */
    public suspend fun getResourcePool(argument: suspend GetResourcePoolPlainArgsBuilder.() -> Unit):
        GetResourcePoolResult {
        val builder = GetResourcePoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourcePoolResultToKotlin(getResourcePoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements vCenter GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Defines the vCenter.
     */
    public suspend fun getVCenter(argument: GetVCenterPlainArgs): GetVCenterResult =
        getVCenterResultToKotlin(getVCenterPlain(argument.toJava()).await())

    /**
     * @see [getVCenter].
     * @param resourceGroupName The Resource Group Name.
     * @param vcenterName Name of the vCenter.
     * @return Defines the vCenter.
     */
    public suspend fun getVCenter(resourceGroupName: String, vcenterName: String): GetVCenterResult {
        val argument = GetVCenterPlainArgs(
            resourceGroupName = resourceGroupName,
            vcenterName = vcenterName,
        )
        return getVCenterResultToKotlin(getVCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getVCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVCenterPlainArgs].
     * @return Defines the vCenter.
     */
    public suspend fun getVCenter(argument: suspend GetVCenterPlainArgsBuilder.() -> Unit):
        GetVCenterResult {
        val builder = GetVCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVCenterResultToKotlin(getVCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements GuestAgent GET method.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-10-01.
     * @param argument null
     * @return Defines the GuestAgent.
     */
    public suspend fun getVMInstanceGuestAgent(argument: GetVMInstanceGuestAgentPlainArgs):
        GetVMInstanceGuestAgentResult =
        getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(argument.toJava()).await())

    /**
     * @see [getVMInstanceGuestAgent].
     * @param resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     * @return Defines the GuestAgent.
     */
    public suspend fun getVMInstanceGuestAgent(resourceUri: String): GetVMInstanceGuestAgentResult {
        val argument = GetVMInstanceGuestAgentPlainArgs(
            resourceUri = resourceUri,
        )
        return getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVMInstanceGuestAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVMInstanceGuestAgentPlainArgs].
     * @return Defines the GuestAgent.
     */
    public suspend
    fun getVMInstanceGuestAgent(argument: suspend GetVMInstanceGuestAgentPlainArgsBuilder.() -> Unit):
        GetVMInstanceGuestAgentResult {
        val builder = GetVMInstanceGuestAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVMInstanceGuestAgentResultToKotlin(getVMInstanceGuestAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements virtual machine GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview.
     * @param argument null
     * @return Define the virtualMachine.
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs):
        GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param resourceGroupName The Resource Group Name.
     * @param virtualMachineName Name of the virtual machine resource.
     * @return Define the virtualMachine.
     */
    public suspend fun getVirtualMachine(resourceGroupName: String, virtualMachineName: String):
        GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return Define the virtualMachine.
     */
    public suspend
    fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a virtual machine instance.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-10-01.
     * @param argument null
     * @return Define the virtualMachineInstance.
     */
    public suspend fun getVirtualMachineInstance(argument: GetVirtualMachineInstancePlainArgs):
        GetVirtualMachineInstanceResult =
        getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineInstance].
     * @param resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     * @return Define the virtualMachineInstance.
     */
    public suspend fun getVirtualMachineInstance(resourceUri: String):
        GetVirtualMachineInstanceResult {
        val argument = GetVirtualMachineInstancePlainArgs(
            resourceUri = resourceUri,
        )
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVirtualMachineInstancePlainArgs].
     * @return Define the virtualMachineInstance.
     */
    public suspend
    fun getVirtualMachineInstance(argument: suspend GetVirtualMachineInstancePlainArgsBuilder.() -> Unit):
        GetVirtualMachineInstanceResult {
        val builder = GetVirtualMachineInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineInstanceResultToKotlin(getVirtualMachineInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements virtual machine template GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the virtualMachineTemplate.
     */
    public suspend fun getVirtualMachineTemplate(argument: GetVirtualMachineTemplatePlainArgs):
        GetVirtualMachineTemplateResult =
        getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineTemplate].
     * @param resourceGroupName The Resource Group Name.
     * @param virtualMachineTemplateName Name of the virtual machine template resource.
     * @return Define the virtualMachineTemplate.
     */
    public suspend fun getVirtualMachineTemplate(
        resourceGroupName: String,
        virtualMachineTemplateName: String,
    ): GetVirtualMachineTemplateResult {
        val argument = GetVirtualMachineTemplatePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineTemplateName = virtualMachineTemplateName,
        )
        return getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVirtualMachineTemplatePlainArgs].
     * @return Define the virtualMachineTemplate.
     */
    public suspend
    fun getVirtualMachineTemplate(argument: suspend GetVirtualMachineTemplatePlainArgsBuilder.() -> Unit):
        GetVirtualMachineTemplateResult {
        val builder = GetVirtualMachineTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineTemplateResultToKotlin(getVirtualMachineTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements virtual network GET method.
     * Azure REST API version: 2022-07-15-preview.
     * Other available API versions: 2023-03-01-preview, 2023-10-01.
     * @param argument null
     * @return Define the virtualNetwork.
     */
    public suspend fun getVirtualNetwork(argument: GetVirtualNetworkPlainArgs):
        GetVirtualNetworkResult =
        getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetwork].
     * @param resourceGroupName The Resource Group Name.
     * @param virtualNetworkName Name of the virtual network resource.
     * @return Define the virtualNetwork.
     */
    public suspend fun getVirtualNetwork(resourceGroupName: String, virtualNetworkName: String):
        GetVirtualNetworkResult {
        val argument = GetVirtualNetworkPlainArgs(
            resourceGroupName = resourceGroupName,
            virtualNetworkName = virtualNetworkName,
        )
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;connectedvmwarevsphere&#46;kotlin&#46;inputs&#46;GetVirtualNetworkPlainArgs].
     * @return Define the virtualNetwork.
     */
    public suspend
    fun getVirtualNetwork(argument: suspend GetVirtualNetworkPlainArgsBuilder.() -> Unit):
        GetVirtualNetworkResult {
        val builder = GetVirtualNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(builtArgument.toJava()).await())
    }
}
