@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.MachineExtensionPropertiesResponseInstanceView
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.MachineExtensionPropertiesResponseInstanceView.Companion.toKotlin as machineExtensionPropertiesResponseInstanceViewToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MachineExtension].
 */
@PulumiTagMarker
public class MachineExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineExtensionArgs = MachineExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineExtensionArgsBuilder.() -> Unit) {
        val builder = MachineExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MachineExtension {
        val builtJavaResource =
            com.pulumi.azurenative.connectedvmwarevsphere.MachineExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineExtension(builtJavaResource)
    }
}

/**
 * Describes a Machine Extension.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2022-01-10-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### Create or Update a Machine Extension (PUT)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineExtension = new AzureNative.ConnectedVMwarevSphere.MachineExtension("machineExtension", new()
 *     {
 *         ExtensionName = "CustomScriptExtension",
 *         Location = "eastus2euap",
 *         Publisher = "Microsoft.Compute",
 *         ResourceGroupName = "myResourceGroup",
 *         Settings =
 *         {
 *             { "commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"" },
 *         },
 *         Type = "CustomScriptExtension",
 *         TypeHandlerVersion = "1.10",
 *         VirtualMachineName = "myMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewMachineExtension(ctx, "machineExtension", &connectedvmwarevsphere.MachineExtensionArgs{
 * 			ExtensionName:     pulumi.String("CustomScriptExtension"),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			Publisher:         pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Settings: pulumi.Any{
 * 				CommandToExecute: "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"",
 * 			},
 * 			Type:               pulumi.String("CustomScriptExtension"),
 * 			TypeHandlerVersion: pulumi.String("1.10"),
 * 			VirtualMachineName: pulumi.String("myMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.MachineExtension;
 * import com.pulumi.azurenative.connectedvmwarevsphere.MachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineExtension = new MachineExtension("machineExtension", MachineExtensionArgs.builder()
 *             .extensionName("CustomScriptExtension")
 *             .location("eastus2euap")
 *             .publisher("Microsoft.Compute")
 *             .resourceGroupName("myResourceGroup")
 *             .settings(Map.of("commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\""))
 *             .type("CustomScriptExtension")
 *             .typeHandlerVersion("1.10")
 *             .virtualMachineName("myMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:MachineExtension CustomScriptExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachines/{virtualMachineName}/extensions/{extensionName}
 * ```
 */
public class MachineExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.connectedvmwarevsphere.MachineExtension,
) : KotlinCustomResource(javaResource, MachineExtensionMapper) {
    /**
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
     */
    public val enableAutomaticUpgrade: Output<Boolean>?
        get() = javaResource.enableAutomaticUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The machine extension instance view.
     */
    public val instanceView: Output<MachineExtensionPropertiesResponseInstanceView>?
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    machineExtensionPropertiesResponseInstanceViewToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    public val protectedSettings: Output<Any>?
        get() = javaResource.protectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the extension handler publisher.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Json formatted public settings for the extension.
     */
    public val settings: Output<Any>?
        get() = javaResource.settings().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the script handler.
     */
    public val typeHandlerVersion: Output<String>?
        get() = javaResource.typeHandlerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MachineExtensionMapper : ResourceMapper<MachineExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.connectedvmwarevsphere.MachineExtension::class == javaResource::class

    override fun map(javaResource: Resource): MachineExtension = MachineExtension(
        javaResource as
            com.pulumi.azurenative.connectedvmwarevsphere.MachineExtension,
    )
}

/**
 * @see [MachineExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineExtension].
 */
public suspend fun machineExtension(
    name: String,
    block: suspend MachineExtensionResourceBuilder.() -> Unit,
): MachineExtension {
    val builder = MachineExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineExtension(name: String): MachineExtension {
    val builder = MachineExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
