@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.VCenterArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.VICredentialArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.VICredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the vCenter.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateVCenter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vCenter = new AzureNative.ConnectedVMwarevSphere.VCenter("vCenter", new()
 *     {
 *         Credentials = new AzureNative.ConnectedVMwarevSphere.Inputs.VICredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Fqdn = "ContosoVMware.contoso.com",
 *         Location = "East US",
 *         Port = 1234,
 *         ResourceGroupName = "testrg",
 *         VcenterName = "ContosoVCenter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVCenter(ctx, "vCenter", &connectedvmwarevsphere.VCenterArgs{
 * 			Credentials: &connectedvmwarevsphere.VICredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Fqdn:              pulumi.String("ContosoVMware.contoso.com"),
 * 			Location:          pulumi.String("East US"),
 * 			Port:              pulumi.Int(1234),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VcenterName:       pulumi.String("ContosoVCenter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VCenter;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vCenter = new VCenter("vCenter", VCenterArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("username", "tempuser")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .fqdn("ContosoVMware.contoso.com")
 *             .location("East US")
 *             .port(1234)
 *             .resourceGroupName("testrg")
 *             .vcenterName("ContosoVCenter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VCenter ContosoVCenter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/vcenters/{vcenterName}
 * ```
 * @property credentials Username / Password Credentials to connect to vcenter.
 * @property extendedLocation Gets or sets the extended location.
 * @property fqdn Gets or sets the FQDN/IPAddress of the vCenter.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property port Gets or sets the port of the vCenter.
 * @property resourceGroupName The Resource Group Name.
 * @property tags Gets or sets the Resource tags.
 * @property vcenterName Name of the vCenter.
 */
public data class VCenterArgs(
    public val credentials: Output<VICredentialArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vcenterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.VCenterArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.VCenterArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.VCenterArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vcenterName(vcenterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VCenterArgs].
 */
@PulumiTagMarker
public class VCenterArgsBuilder internal constructor() {
    private var credentials: Output<VICredentialArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdn: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vcenterName: Output<String>? = null

    /**
     * @param value Username / Password Credentials to connect to vcenter.
     */
    @JvmName("mbixxuhfqabboxka")
    public suspend fun credentials(`value`: Output<VICredentialArgs>) {
        this.credentials = value
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("htqihensojtmjicb")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the vCenter.
     */
    @JvmName("lwxkwhjdaakjtaui")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("sdhfefroauhjdsop")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("rkowgkhauemkoobe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the port of the vCenter.
     */
    @JvmName("vlsiwaqicdxfphfw")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("mocbokmeimhsugmy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("uwhnpltamgcybhek")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("hsbolxgituwvtchg")
    public suspend fun vcenterName(`value`: Output<String>) {
        this.vcenterName = value
    }

    /**
     * @param value Username / Password Credentials to connect to vcenter.
     */
    @JvmName("fhfmdileqhuuphiy")
    public suspend fun credentials(`value`: VICredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Username / Password Credentials to connect to vcenter.
     */
    @JvmName("elvsvxhvsmmwveck")
    public suspend fun credentials(argument: suspend VICredentialArgsBuilder.() -> Unit) {
        val toBeMapped = VICredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("ggpcpyewqohfjbqk")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("hoyqxltnhuilgbkm")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the vCenter.
     */
    @JvmName("xstypqpdepwlrcme")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("rctesdxiqkfqqcls")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("rdhntxpwceqdrnex")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the port of the vCenter.
     */
    @JvmName("gqgfwhkvvyuaxeuh")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("nxehlxhvpwtilawu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("gfiseabrwxonbuxc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("kbxnlyrwydsmaayu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("gypefhlwoqycwdqu")
    public suspend fun vcenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcenterName = mapped
    }

    internal fun build(): VCenterArgs = VCenterArgs(
        credentials = credentials,
        extendedLocation = extendedLocation,
        fqdn = fqdn,
        kind = kind,
        location = location,
        port = port,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vcenterName = vcenterName,
    )
}
