@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.FirmwareType
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestAgentProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestAgentProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.OsProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.OsProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.PlacementProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.PlacementProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.SecurityProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.SecurityProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the virtualMachine.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.ConnectedVMwarevSphere.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.HardwareProfileArgs
 *         {
 *             MemorySizeMB = 4196,
 *             NumCPUs = 4,
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         ResourcePoolId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool",
 *         TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         VirtualMachineName = "DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualMachine(ctx, "virtualMachine", &connectedvmwarevsphere.VirtualMachineArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &connectedvmwarevsphere.HardwareProfileArgs{
 * 				MemorySizeMB: pulumi.Int(4196),
 * 				NumCPUs:      pulumi.Int(4),
 * 			},
 * 			Location:           pulumi.String("East US"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ResourcePoolId:     pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool"),
 * 			TemplateId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate"),
 * 			VCenterId:          pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			VirtualMachineName: pulumi.String("DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .hardwareProfile(Map.ofEntries(
 *                 Map.entry("memorySizeMB", 4196),
 *                 Map.entry("numCPUs", 4)
 *             ))
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .resourcePoolId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool")
 *             .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .virtualMachineName("DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualMachine DemoVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachines/{virtualMachineName}
 * ```
 * @property extendedLocation Gets or sets the extended location.
 * @property firmwareType Firmware type
 * @property guestAgentProfile Guest agent status properties.
 * @property hardwareProfile Hardware properties.
 * @property identity The identity of the resource.
 * @property inventoryItemId Gets or sets the inventory Item ID for the virtual machine.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property placementProfile Placement properties.
 * @property resourceGroupName The Resource Group Name.
 * @property resourcePoolId Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will
 * deploy.
 * @property securityProfile Gets the security profile.
 * @property smbiosUuid Gets or sets the SMBIOS UUID of the vm.
 * @property storageProfile Storage properties.
 * @property tags Gets or sets the Resource tags.
 * @property templateId Gets or sets the ARM Id of the template resource to deploy the virtual machine.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
 * @property virtualMachineName Name of the virtual machine resource.
 */
public data class VirtualMachineArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val firmwareType: Output<Either<String, FirmwareType>>? = null,
    public val guestAgentProfile: Output<GuestAgentProfileArgs>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val moRefId: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OsProfileArgs>? = null,
    public val placementProfile: Output<PlacementProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourcePoolId: Output<String>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val smbiosUuid: Output<String>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateId: Output<String>? = null,
    public val vCenterId: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firmwareType(
                firmwareType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .guestAgentProfile(guestAgentProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moRefId(moRefId?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .placementProfile(placementProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourcePoolId(resourcePoolId?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .smbiosUuid(smbiosUuid?.applyValue({ args0 -> args0 }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .vCenterId(vCenterId?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var firmwareType: Output<Either<String, FirmwareType>>? = null

    private var guestAgentProfile: Output<GuestAgentProfileArgs>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var inventoryItemId: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var moRefId: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OsProfileArgs>? = null

    private var placementProfile: Output<PlacementProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourcePoolId: Output<String>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var smbiosUuid: Output<String>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateId: Output<String>? = null

    private var vCenterId: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("itigskmcmpibvtdu")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Firmware type
     */
    @JvmName("xfxedrkflpydxncu")
    public suspend fun firmwareType(`value`: Output<Either<String, FirmwareType>>) {
        this.firmwareType = value
    }

    /**
     * @param value Guest agent status properties.
     */
    @JvmName("ltbcfjovojxxmitg")
    public suspend fun guestAgentProfile(`value`: Output<GuestAgentProfileArgs>) {
        this.guestAgentProfile = value
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("opvcmxxafymmkdgo")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("tkctqrpcwgdpnymc")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the virtual machine.
     */
    @JvmName("rrjyafotibpijoic")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("qlovujtufjorjyvo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("mxsmpwfoaohfhdad")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
     */
    @JvmName("fkycptwdsitqppoc")
    public suspend fun moRefId(`value`: Output<String>) {
        this.moRefId = value
    }

    /**
     * @param value Network properties.
     */
    @JvmName("omadxssfkkwjujsi")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OS properties.
     */
    @JvmName("bmsxpniyeqsdyhml")
    public suspend fun osProfile(`value`: Output<OsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Placement properties.
     */
    @JvmName("tlrrxhlexnudotag")
    public suspend fun placementProfile(`value`: Output<PlacementProfileArgs>) {
        this.placementProfile = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("qmfnennmtjxpfnbj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will
     * deploy.
     */
    @JvmName("autfuewrscixtlhk")
    public suspend fun resourcePoolId(`value`: Output<String>) {
        this.resourcePoolId = value
    }

    /**
     * @param value Gets the security profile.
     */
    @JvmName("wkgoeegcvogiukck")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Gets or sets the SMBIOS UUID of the vm.
     */
    @JvmName("arfpmwgladytximj")
    public suspend fun smbiosUuid(`value`: Output<String>) {
        this.smbiosUuid = value
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("oushfoeodrmwxpro")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("gffmlcluratljgke")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the ARM Id of the template resource to deploy the virtual machine.
     */
    @JvmName("cirjbmfmfdkyrvrk")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("ngjlwoxrvjdfnbnh")
    public suspend fun vCenterId(`value`: Output<String>) {
        this.vCenterId = value
    }

    /**
     * @param value Name of the virtual machine resource.
     */
    @JvmName("hoclttcprfqdavjp")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("hbofplfthoymlaqm")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("qdsrpclegpsbfxop")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Firmware type
     */
    @JvmName("tncmgujxtivcyvow")
    public suspend fun firmwareType(`value`: Either<String, FirmwareType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Firmware type
     */
    @JvmName("jftgvdoorlhvasdl")
    public fun firmwareType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirmwareType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Firmware type
     */
    @JvmName("vmuwsanitdlomruo")
    public fun firmwareType(`value`: FirmwareType) {
        val toBeMapped = Either.ofRight<String, FirmwareType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Guest agent status properties.
     */
    @JvmName("qbpompmhitpttdfh")
    public suspend fun guestAgentProfile(`value`: GuestAgentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestAgentProfile = mapped
    }

    /**
     * @param argument Guest agent status properties.
     */
    @JvmName("vfugxornshhktdce")
    public suspend fun guestAgentProfile(argument: suspend GuestAgentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GuestAgentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guestAgentProfile = mapped
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("jwujujhpitvdcwbc")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Hardware properties.
     */
    @JvmName("jigstkyqccwuucmn")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("meulmgwteevbmvta")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("xqcofmsejucioror")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the virtual machine.
     */
    @JvmName("bjuqfufkjptihxqm")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("cohonuwbrhpnttww")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("uxtfksggcfispwbc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
     */
    @JvmName("pnlygfihxilagunu")
    public suspend fun moRefId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moRefId = mapped
    }

    /**
     * @param value Network properties.
     */
    @JvmName("tkkfiglhposwojne")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network properties.
     */
    @JvmName("jbuxqnaudbqcewuw")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OS properties.
     */
    @JvmName("oochtcklfvtdihhe")
    public suspend fun osProfile(`value`: OsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OS properties.
     */
    @JvmName("hahgffpejnxhvrfr")
    public suspend fun osProfile(argument: suspend OsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Placement properties.
     */
    @JvmName("onomacgvwfrbsokr")
    public suspend fun placementProfile(`value`: PlacementProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementProfile = mapped
    }

    /**
     * @param argument Placement properties.
     */
    @JvmName("npoguvbptcaigpsu")
    public suspend fun placementProfile(argument: suspend PlacementProfileArgsBuilder.() -> Unit) {
        val toBeMapped = PlacementProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.placementProfile = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("ndyualvdaqlinobb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will
     * deploy.
     */
    @JvmName("skbyqcnfqseyvedr")
    public suspend fun resourcePoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePoolId = mapped
    }

    /**
     * @param value Gets the security profile.
     */
    @JvmName("lkarabgmfiuurrjy")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Gets the security profile.
     */
    @JvmName("bmxkbwdpkpkuowcw")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Gets or sets the SMBIOS UUID of the vm.
     */
    @JvmName("ooiwuoclbdbexbvx")
    public suspend fun smbiosUuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbiosUuid = mapped
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("bxlvldypxaumopuv")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage properties.
     */
    @JvmName("ahbhuaygupnpgvtu")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("ksrisgdckusdjfsa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("mpxnxpwxportgxrl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the template resource to deploy the virtual machine.
     */
    @JvmName("ubpdqcpepqtfkymo")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("jlxfvrrmnodxxcly")
    public suspend fun vCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCenterId = mapped
    }

    /**
     * @param value Name of the virtual machine resource.
     */
    @JvmName("eyexgmmimqwdfxwr")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        extendedLocation = extendedLocation,
        firmwareType = firmwareType,
        guestAgentProfile = guestAgentProfile,
        hardwareProfile = hardwareProfile,
        identity = identity,
        inventoryItemId = inventoryItemId,
        kind = kind,
        location = location,
        moRefId = moRefId,
        networkProfile = networkProfile,
        osProfile = osProfile,
        placementProfile = placementProfile,
        resourceGroupName = resourceGroupName,
        resourcePoolId = resourcePoolId,
        securityProfile = securityProfile,
        smbiosUuid = smbiosUuid,
        storageProfile = storageProfile,
        tags = tags,
        templateId = templateId,
        vCenterId = vCenterId,
        virtualMachineName = virtualMachineName,
    )
}
