@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetDatastorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datastoreName Name of the datastore.
 * @property resourceGroupName The Resource Group Name.
 */
public data class GetDatastorePlainArgs(
    public val datastoreName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetDatastorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetDatastorePlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetDatastorePlainArgs.builder()
            .datastoreName(datastoreName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatastorePlainArgs].
 */
@PulumiTagMarker
public class GetDatastorePlainArgsBuilder internal constructor() {
    private var datastoreName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the datastore.
     */
    @JvmName("qdgopaheijmhyxym")
    public suspend fun datastoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datastoreName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("cnuetqjuhtcjyaaw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatastorePlainArgs = GetDatastorePlainArgs(
        datastoreName = datastoreName ?: throw PulumiNullFieldException("datastoreName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
