@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetResourcePoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The Resource Group Name.
 * @property resourcePoolName Name of the resourcePool.
 */
public data class GetResourcePoolPlainArgs(
    public val resourceGroupName: String,
    public val resourcePoolName: String,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetResourcePoolPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetResourcePoolPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetResourcePoolPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourcePoolName(resourcePoolName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePoolPlainArgs].
 */
@PulumiTagMarker
public class GetResourcePoolPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourcePoolName: String? = null

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("xqrxlpyhtvgawony")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resourcePool.
     */
    @JvmName("vsxytuirmknbmjdm")
    public suspend fun resourcePoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourcePoolName = mapped
    }

    internal fun build(): GetResourcePoolPlainArgs = GetResourcePoolPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourcePoolName = resourcePoolName ?: throw PulumiNullFieldException("resourcePoolName"),
    )
}
