@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.HttpProxyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HTTP Proxy configuration for the VM.
 * @property httpsProxy Gets or sets httpsProxy url.
 */
public data class HttpProxyConfigurationArgs(
    public val httpsProxy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.HttpProxyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.HttpProxyConfigurationArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.HttpProxyConfigurationArgs.builder()
            .httpsProxy(httpsProxy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpProxyConfigurationArgs].
 */
@PulumiTagMarker
public class HttpProxyConfigurationArgsBuilder internal constructor() {
    private var httpsProxy: Output<String>? = null

    /**
     * @param value Gets or sets httpsProxy url.
     */
    @JvmName("nqjfyklcwoverkwu")
    public suspend fun httpsProxy(`value`: Output<String>) {
        this.httpsProxy = value
    }

    /**
     * @param value Gets or sets httpsProxy url.
     */
    @JvmName("ftixsjjjgdjfjvow")
    public suspend fun httpsProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsProxy = mapped
    }

    internal fun build(): HttpProxyConfigurationArgs = HttpProxyConfigurationArgs(
        httpsProxy = httpsProxy,
    )
}
