@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the network interfaces of the virtual machine.
 * @property networkInterfaces Gets or sets the list of network interfaces associated with the virtual machine.
 */
public data class NetworkProfileArgs(
    public val networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.NetworkProfileArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null

    /**
     * @param value Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("jfummuarequktedn")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("rsveucvvdkjwkoqm")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("ltrqaxkehjhthiag")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("fjsmbdmyrlsyyocl")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("nkkkwyyosodmrgog")
    public suspend
    fun networkInterfaces(argument: List<suspend NetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("wvglywsqcaanwvsc")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend NetworkInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("xptskrhfakxqlrup")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkInterfaceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Gets or sets the list of network interfaces associated with the virtual machine.
     */
    @JvmName("jmpmkoqbbodjgyci")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        networkInterfaces = networkInterfaces,
    )
}
