@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the vCenter.
 * @property connectionStatus Gets or sets the connection status to the vCenter.
 * @property credentials Username / Password Credentials to connect to vcenter.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property extendedLocation Gets or sets the extended location.
 * @property fqdn Gets or sets the FQDN/IPAddress of the vCenter.
 * @property id Gets or sets the Id.
 * @property instanceUuid Gets or sets the instance UUID of the vCenter.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property name Gets or sets the name.
 * @property port Gets or sets the port of the vCenter.
 * @property provisioningState Gets or sets the provisioning state.
 * @property statuses The resource status information.
 * @property systemData The system data.
 * @property tags Gets or sets the Resource tags.
 * @property type Gets or sets the type of the resource.
 * @property uuid Gets or sets a unique identifier for this resource.
 * @property version Gets or sets the version of the vCenter.
 */
public data class GetVCenterResult(
    public val connectionStatus: String,
    public val credentials: VICredentialResponse? = null,
    public val customResourceName: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val fqdn: String,
    public val id: String,
    public val instanceUuid: String,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val port: Int? = null,
    public val provisioningState: String,
    public val statuses: List<ResourceStatusResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetVCenterResult):
            GetVCenterResult = GetVCenterResult(
            connectionStatus = javaType.connectionStatus(),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VICredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customResourceName = javaType.customResourceName(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fqdn = javaType.fqdn(),
            id = javaType.id(),
            instanceUuid = javaType.instanceUuid(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid(),
            version = javaType.version(),
        )
    }
}
