@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Suppress

/**
 * Specifies the Security profile settings for the virtual machine.
 * @property uefiSettings Specifies the security settings like secure boot used while creating the virtual machine.
 */
public data class SecurityProfileResponse(
    public val uefiSettings: UefiSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.SecurityProfileResponse):
            SecurityProfileResponse = SecurityProfileResponse(
            uefiSettings = javaType.uefiSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.UefiSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
