@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Specifies the security settings like secure boot used while creating the virtual machine.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the virtual machine.
 */
public data class UefiSettingsResponse(
    public val secureBootEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.UefiSettingsResponse):
            UefiSettingsResponse = UefiSettingsResponse(
            secureBootEnabled = javaType.secureBootEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
