@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of threshold
 */
public enum class ThresholdType(
    public val javaValue: com.pulumi.azurenative.consumption.enums.ThresholdType,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.enums.ThresholdType> {
    /**
     * Actual costs budget alerts notify when the actual accrued cost exceeds the allocated budget .
     */
    Actual(com.pulumi.azurenative.consumption.enums.ThresholdType.Actual),

    /**
     * Forecasted costs budget alerts provide advanced notification that your spending trends are likely to exceed your allocated budget, as it relies on forecasted cost predictions.
     */
    Forecasted(com.pulumi.azurenative.consumption.enums.ThresholdType.Forecasted),
    ;

    override fun toJava(): com.pulumi.azurenative.consumption.enums.ThresholdType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.enums.ThresholdType):
            ThresholdType = ThresholdType.values().first { it.javaValue == javaType }
    }
}
